/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingAccountDetail;
import au.org.consumerdatastandards.holder.model.BankingTermDepositAccount;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
public class BankingTermDepositAccount {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    @JsonIgnore
    @ManyToOne
    private BankingAccountDetail bankingAccountDetail;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate lodgementDate;
    private String maturityAmount;
    private String maturityCurrency;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate maturityDate;
    private MaturityInstructions maturityInstructions;

    public BankingAccountDetail getBankingAccountDetail() {
        return this.bankingAccountDetail;
    }

    public void setBankingAccountDetail(BankingAccountDetail bankingAccountDetail) {
        this.bankingAccountDetail = bankingAccountDetail;
    }

    public BankingTermDepositAccount lodgementDate(LocalDate lodgementDate) {
        this.lodgementDate = lodgementDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The lodgement date of the original deposit")
    public LocalDate getLodgementDate() {
        return this.lodgementDate;
    }

    public void setLodgementDate(LocalDate lodgementDate) {
        this.lodgementDate = lodgementDate;
    }

    public BankingTermDepositAccount maturityAmount(String maturityAmount) {
        this.maturityAmount = maturityAmount;
        return this;
    }

    @ApiModelProperty(value="Amount to be paid upon maturity. If absent it implies the amount to paid is variable and cannot currently be calculated")
    public String getMaturityAmount() {
        return this.maturityAmount;
    }

    public void setMaturityAmount(String maturityAmount) {
        this.maturityAmount = maturityAmount;
    }

    public BankingTermDepositAccount maturityCurrency(String maturityCurrency) {
        this.maturityCurrency = maturityCurrency;
        return this;
    }

    @ApiModelProperty(value="If absent assumes AUD")
    public String getMaturityCurrency() {
        return this.maturityCurrency;
    }

    public void setMaturityCurrency(String maturityCurrency) {
        this.maturityCurrency = maturityCurrency;
    }

    public BankingTermDepositAccount maturityDate(LocalDate maturityDate) {
        this.maturityDate = maturityDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Maturity date for the term deposit")
    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    public void setMaturityDate(LocalDate maturityDate) {
        this.maturityDate = maturityDate;
    }

    public BankingTermDepositAccount maturityInstructions(MaturityInstructions maturityInstructions) {
        this.maturityInstructions = maturityInstructions;
        return this;
    }

    @ApiModelProperty(required=true)
    public MaturityInstructions getMaturityInstructions() {
        return this.maturityInstructions;
    }

    public void setMaturityInstructions(MaturityInstructions maturityInstructions) {
        this.maturityInstructions = maturityInstructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingTermDepositAccount bankingTermDepositAccount = (BankingTermDepositAccount)o;
        return Objects.equals(this.id, bankingTermDepositAccount.id) && Objects.equals(this.bankingAccountDetail, bankingTermDepositAccount.bankingAccountDetail) && Objects.equals(this.lodgementDate, bankingTermDepositAccount.lodgementDate) && Objects.equals(this.maturityAmount, bankingTermDepositAccount.maturityAmount) && Objects.equals(this.maturityCurrency, bankingTermDepositAccount.maturityCurrency) && Objects.equals(this.maturityDate, bankingTermDepositAccount.maturityDate) && Objects.equals(this.maturityInstructions, bankingTermDepositAccount.maturityInstructions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bankingAccountDetail, this.lodgementDate, this.maturityAmount, this.maturityCurrency, this.maturityDate, this.maturityInstructions);
    }

    public String toString() {
        return "class BankingTermDepositAccount {\n   id: " + this.toIndentedString((Object)this.id) + "\n   bankingAccountDetail: " + this.toIndentedString((Object)this.bankingAccountDetail) + "\n   lodgementDate: " + this.toIndentedString((Object)this.lodgementDate) + "\n   maturityAmount: " + this.toIndentedString((Object)this.maturityAmount) + "\n   maturityCurrency: " + this.toIndentedString((Object)this.maturityCurrency) + "\n   maturityDate: " + this.toIndentedString((Object)this.maturityDate) + "\n   maturityInstructions: " + this.toIndentedString((Object)this.maturityInstructions) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

