/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Embeddable;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(description="Indicates that the payment is a once off payment on a specific future date. Mandatory if recurrenceUType is set to onceOff")
@Embeddable
public class BankingScheduledPaymentRecurrenceOnceOff {
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate paymentDate;

    public BankingScheduledPaymentRecurrenceOnceOff paymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The scheduled date for the once off payment")
    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentRecurrenceOnceOff bankingScheduledPaymentRecurrenceOnceOff = (BankingScheduledPaymentRecurrenceOnceOff)o;
        return Objects.equals(this.paymentDate, bankingScheduledPaymentRecurrenceOnceOff.paymentDate);
    }

    public int hashCode() {
        return Objects.hash(this.paymentDate);
    }

    public String toString() {
        return "class BankingScheduledPaymentRecurrenceOnceOff {\n   paymentDate: " + this.toIndentedString((Object)this.paymentDate) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

