/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingProductAdditionalInformation;
import au.org.consumerdatastandards.holder.model.BankingProductBundle;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.BankingProductConstraint;
import au.org.consumerdatastandards.holder.model.BankingProductDepositRate;
import au.org.consumerdatastandards.holder.model.BankingProductDetail;
import au.org.consumerdatastandards.holder.model.BankingProductEligibility;
import au.org.consumerdatastandards.holder.model.BankingProductFeature;
import au.org.consumerdatastandards.holder.model.BankingProductFee;
import au.org.consumerdatastandards.holder.model.BankingProductLendingRate;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@Table(name="BankingProduct")
public class BankingProductV1Detail
implements BankingProductDetail {
    @Id
    private String productId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime effectiveFrom;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime effectiveTo;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime lastUpdated;
    private BankingProductCategory productCategory;
    private String name;
    @Column(length=2048)
    private String description;
    private String brand;
    private String brandName;
    private String applicationUri;
    private Boolean isTailored;
    @OneToOne(cascade={CascadeType.ALL})
    private BankingProductAdditionalInformation additionalInformation;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_bundles", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="bundle_id")})
    @Valid
    private List<BankingProductBundle> bundles = null;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_constraints", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="constraint_id")})
    @Valid
    private List<BankingProductConstraint> constraints = null;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_deposit_rates", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="deposit_rate_id")})
    @Valid
    private List<BankingProductDepositRate> depositRates = null;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_eligibility", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="eligibility_id")})
    @Valid
    private List<BankingProductEligibility> eligibility = null;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_features", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="feature_id")})
    @Valid
    private List<BankingProductFeature> features = null;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_fees", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="fee_id")})
    @Valid
    private List<BankingProductFee> fees = null;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_lending_rates", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="lending_rate_id")})
    @Valid
    private List<BankingProductLendingRate> lendingRates = null;

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public OffsetDateTime getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(OffsetDateTime effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public OffsetDateTime getEffectiveTo() {
        return this.effectiveTo;
    }

    public void setEffectiveTo(OffsetDateTime effectiveTo) {
        this.effectiveTo = effectiveTo;
    }

    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public BankingProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(BankingProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public void setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
    }

    public Boolean getIsTailored() {
        return this.isTailored;
    }

    public void setIsTailored(Boolean tailored) {
        this.isTailored = tailored;
    }

    public BankingProductV1Detail additionalInformation(BankingProductAdditionalInformation additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @Valid
    public BankingProductAdditionalInformation getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(BankingProductAdditionalInformation additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public BankingProductV1Detail applicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public BankingProductV1Detail brand(String brand) {
        this.brand = brand;
        return this;
    }

    public BankingProductV1Detail brandName(String brandName) {
        this.brandName = brandName;
        return this;
    }

    public BankingProductV1Detail description(String description) {
        this.description = description;
        return this;
    }

    public BankingProductV1Detail effectiveFrom(OffsetDateTime effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
        return this;
    }

    public BankingProductV1Detail effectiveTo(OffsetDateTime effectiveTo) {
        this.effectiveTo = effectiveTo;
        return this;
    }

    public BankingProductV1Detail isTailored(Boolean isTailored) {
        this.isTailored = isTailored;
        return this;
    }

    public BankingProductV1Detail lastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    public BankingProductV1Detail name(String name) {
        this.name = name;
        return this;
    }

    public BankingProductV1Detail productCategory(BankingProductCategory productCategory) {
        this.productCategory = productCategory;
        return this;
    }

    public BankingProductV1Detail productId(String productId) {
        this.productId = productId;
        return this;
    }

    public BankingProductV1Detail bundles(List<BankingProductBundle> bundles) {
        this.bundles = bundles;
        return this;
    }

    public BankingProductV1Detail addBundlesItem(BankingProductBundle bundlesItem) {
        if (this.bundles == null) {
            this.bundles = new ArrayList();
        }
        this.bundles.add(bundlesItem);
        return this;
    }

    @Valid
    public List<BankingProductBundle> getBundles() {
        return this.bundles;
    }

    public void setBundles(List<BankingProductBundle> bundles) {
        this.bundles = bundles;
    }

    public BankingProductV1Detail constraints(List<BankingProductConstraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public BankingProductV1Detail addConstraintsItem(BankingProductConstraint constraintsItem) {
        if (this.constraints == null) {
            this.constraints = new ArrayList();
        }
        this.constraints.add(constraintsItem);
        return this;
    }

    @Valid
    public List<BankingProductConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<BankingProductConstraint> constraints) {
        this.constraints = constraints;
    }

    public BankingProductV1Detail depositRates(List<BankingProductDepositRate> depositRates) {
        this.depositRates = depositRates;
        return this;
    }

    public BankingProductV1Detail addDepositRatesItem(BankingProductDepositRate depositRatesItem) {
        if (this.depositRates == null) {
            this.depositRates = new ArrayList();
        }
        this.depositRates.add(depositRatesItem);
        return this;
    }

    @Valid
    public List<BankingProductDepositRate> getDepositRates() {
        return this.depositRates;
    }

    public void setDepositRates(List<BankingProductDepositRate> depositRates) {
        this.depositRates = depositRates;
    }

    public BankingProductV1Detail eligibility(List<BankingProductEligibility> eligibility) {
        this.eligibility = eligibility;
        return this;
    }

    public BankingProductV1Detail addEligibilityItem(BankingProductEligibility eligibilityItem) {
        if (this.eligibility == null) {
            this.eligibility = new ArrayList();
        }
        this.eligibility.add(eligibilityItem);
        return this;
    }

    @Valid
    public List<BankingProductEligibility> getEligibility() {
        return this.eligibility;
    }

    public void setEligibility(List<BankingProductEligibility> eligibility) {
        this.eligibility = eligibility;
    }

    public BankingProductV1Detail features(List<BankingProductFeature> features) {
        this.features = features;
        return this;
    }

    public BankingProductV1Detail addFeaturesItem(BankingProductFeature featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList();
        }
        this.features.add(featuresItem);
        return this;
    }

    @Valid
    public List<BankingProductFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<BankingProductFeature> features) {
        this.features = features;
    }

    public BankingProductV1Detail fees(List<BankingProductFee> fees) {
        this.fees = fees;
        return this;
    }

    public BankingProductV1Detail addFeesItem(BankingProductFee feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Valid
    public List<BankingProductFee> getFees() {
        return this.fees;
    }

    public void setFees(List<BankingProductFee> fees) {
        this.fees = fees;
    }

    public BankingProductV1Detail lendingRates(List<BankingProductLendingRate> lendingRates) {
        this.lendingRates = lendingRates;
        return this;
    }

    public BankingProductV1Detail addLendingRatesItem(BankingProductLendingRate lendingRatesItem) {
        if (this.lendingRates == null) {
            this.lendingRates = new ArrayList();
        }
        this.lendingRates.add(lendingRatesItem);
        return this;
    }

    @Valid
    public List<BankingProductLendingRate> getLendingRates() {
        return this.lendingRates;
    }

    public void setLendingRates(List<BankingProductLendingRate> lendingRates) {
        this.lendingRates = lendingRates;
    }

    public String toString() {
        return "BankingProductDetail{productId='" + this.productId + '\'' + ", additionalInformation=" + this.additionalInformation + ", applicationUri='" + this.applicationUri + '\'' + ", brand='" + this.brand + '\'' + ", brandName='" + this.brandName + '\'' + ", description='" + this.description + '\'' + ", effectiveFrom=" + this.effectiveFrom + ", effectiveTo=" + this.effectiveTo + ", isTailored=" + this.isTailored + ", lastUpdated=" + this.lastUpdated + ", name='" + this.name + '\'' + ", productCategory=" + this.productCategory + ", bundles=" + this.bundles + ", constraints=" + this.constraints + ", depositRates=" + this.depositRates + ", eligibility=" + this.eligibility + ", features=" + this.features + ", fees=" + this.fees + ", lendingRates=" + this.lendingRates + '}';
    }
}

