/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class BankingDomesticPayeeAccount {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String accountName;
    private String accountNumber;
    private String bsb;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingDomesticPayeeAccount accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the account to pay to")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public BankingDomesticPayeeAccount accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of the account to pay to")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BankingDomesticPayeeAccount bsb(String bsb) {
        this.bsb = bsb;
        return this;
    }

    @ApiModelProperty(required=true, value="BSB of the account to pay to")
    public String getBsb() {
        return this.bsb;
    }

    public void setBsb(String bsb) {
        this.bsb = bsb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingDomesticPayeeAccount bankingDomesticPayeeAccount = (BankingDomesticPayeeAccount)o;
        return Objects.equals(this.id, bankingDomesticPayeeAccount.id) && Objects.equals(this.accountName, bankingDomesticPayeeAccount.accountName) && Objects.equals(this.accountNumber, bankingDomesticPayeeAccount.accountNumber) && Objects.equals(this.bsb, bankingDomesticPayeeAccount.bsb);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountName, this.accountNumber, this.bsb);
    }

    public String toString() {
        return "class BankingDomesticPayeeAccount {\n   id: " + this.toIndentedString((Object)this.id) + "\n   accountName: " + this.toIndentedString((Object)this.accountName) + "\n   accountNumber: " + this.toIndentedString((Object)this.accountNumber) + "\n   bsb: " + this.toIndentedString((Object)this.bsb) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

