/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class BankingBalancePurse {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String amount;
    private String currency;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingBalancePurse amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The balance available for this additional currency purse")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public BankingBalancePurse currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency for the purse")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingBalancePurse bankingBalancePurse = (BankingBalancePurse)o;
        return Objects.equals(this.id, bankingBalancePurse.id) && Objects.equals(this.amount, bankingBalancePurse.amount) && Objects.equals(this.currency, bankingBalancePurse.currency);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amount, this.currency);
    }

    public String toString() {
        return "class BankingBalancePurse {\n   id: " + this.toIndentedString((Object)this.id) + "\n   amount: " + this.toIndentedString((Object)this.amount) + "\n   currency: " + this.toIndentedString((Object)this.currency) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

