/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingAccountDetail;
import au.org.consumerdatastandards.holder.model.BankingAccountProductFeature;
import au.org.consumerdatastandards.holder.model.BankingCreditCardAccount;
import au.org.consumerdatastandards.holder.model.BankingLoanAccount;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.BankingProductDepositRate;
import au.org.consumerdatastandards.holder.model.BankingProductFee;
import au.org.consumerdatastandards.holder.model.BankingProductLendingRate;
import au.org.consumerdatastandards.holder.model.BankingTermDepositAccount;
import au.org.consumerdatastandards.holder.model.CommonPhysicalAddress;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
@Table(name="BankingAccount")
public class BankingAccountDetail {
    @Id
    private String accountId;
    @JsonIgnore
    private String userId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate creationDate;
    private String displayName;
    @Transient
    private Boolean isOwned;
    private String maskedNumber;
    private String nickname;
    private BankingAccount.OpenStatus openStatus;
    private BankingProductCategory productCategory;
    private String productName;
    private String accountNumber;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="banking_account_addresses", joinColumns={@JoinColumn(name="banking_account_id")}, inverseJoinColumns={@JoinColumn(name="common_physical_address_id")})
    private List<CommonPhysicalAddress> addresses;
    private String bsb;
    private String bundleName;
    @ManyToOne
    private BankingCreditCardAccount creditCard;
    private String depositRate;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="banking_account_deposit_rates", joinColumns={@JoinColumn(name="banking_account_id")}, inverseJoinColumns={@JoinColumn(name="deposit_rate_id")})
    private List<BankingProductDepositRate> depositRates;
    @OneToMany(mappedBy="bankingAccountDetail")
    private List<BankingAccountProductFeature> features;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="banking_account_fees", joinColumns={@JoinColumn(name="banking_account_id")}, inverseJoinColumns={@JoinColumn(name="product_fee_id")})
    private List<BankingProductFee> fees;
    private String lendingRate;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="banking_account_lending_rates", joinColumns={@JoinColumn(name="banking_account_id")}, inverseJoinColumns={@JoinColumn(name="lending_rate_id")})
    private List<BankingProductLendingRate> lendingRates;
    @ManyToOne
    private BankingLoanAccount loan;
    private SpecificAccountUType specificAccountUType;
    @OneToMany(mappedBy="bankingAccountDetail")
    private List<BankingTermDepositAccount> termDeposit;

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Boolean getIsOwned() {
        return this.isOwned;
    }

    public void setIsOwned(Boolean owned) {
        this.isOwned = owned;
    }

    public String getMaskedNumber() {
        return this.maskedNumber;
    }

    public void setMaskedNumber(String maskedNumber) {
        this.maskedNumber = maskedNumber;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public BankingAccount.OpenStatus getOpenStatus() {
        return this.openStatus;
    }

    public void setOpenStatus(BankingAccount.OpenStatus openStatus) {
        this.openStatus = openStatus;
    }

    public BankingProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(BankingProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BankingAccountDetail accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public BankingAccountDetail creationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public BankingAccountDetail displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public BankingAccountDetail isOwned(Boolean isOwned) {
        this.isOwned = isOwned;
        return this;
    }

    public BankingAccountDetail maskedNumber(String maskedNumber) {
        this.maskedNumber = maskedNumber;
        return this;
    }

    public BankingAccountDetail nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public BankingAccountDetail openStatus(BankingAccount.OpenStatus openStatus) {
        this.openStatus = openStatus;
        return this;
    }

    public BankingAccountDetail productCategory(BankingProductCategory productCategory) {
        this.productCategory = productCategory;
        return this;
    }

    public BankingAccountDetail productName(String productName) {
        this.productName = productName;
        return this;
    }

    public BankingAccountDetail accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(value="The unmasked account number for the account. Should not be supplied if the account number is a PAN requiring PCI compliance. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BankingAccountDetail addresses(List<CommonPhysicalAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public BankingAccountDetail addItem(CommonPhysicalAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @ApiModelProperty(value="The addresses for the account to be used for correspondence")
    public List<CommonPhysicalAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<CommonPhysicalAddress> addresses) {
        this.addresses = addresses;
    }

    public BankingAccountDetail bsb(String bsb) {
        this.bsb = bsb;
        return this;
    }

    @ApiModelProperty(value="The unmasked BSB for the account. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces")
    public String getBsb() {
        return this.bsb;
    }

    public void setBsb(String bsb) {
        this.bsb = bsb;
    }

    public BankingAccountDetail bundleName(String bundleName) {
        this.bundleName = bundleName;
        return this;
    }

    @ApiModelProperty(value="Optional field to indicate if this account is part of a bundle that is providing additional benefit for to the customer")
    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public BankingAccountDetail creditCard(BankingCreditCardAccount creditCard) {
        this.creditCard = creditCard;
        return this;
    }

    @ApiModelProperty
    public BankingCreditCardAccount getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(BankingCreditCardAccount creditCard) {
        this.creditCard = creditCard;
    }

    public BankingAccountDetail depositRate(String depositRate) {
        this.depositRate = depositRate;
        return this;
    }

    @ApiModelProperty(value="current rate to calculate interest earned being applied to deposit balances as it stands at the time of the API call")
    public String getDepositRate() {
        return this.depositRate;
    }

    public void setDepositRate(String depositRate) {
        this.depositRate = depositRate;
    }

    public BankingAccountDetail depositRates(List<BankingProductDepositRate> depositRates) {
        this.depositRates = depositRates;
        return this;
    }

    public BankingAccountDetail addItem(BankingProductDepositRate depositRatesItem) {
        if (this.depositRates == null) {
            this.depositRates = new ArrayList();
        }
        this.depositRates.add(depositRatesItem);
        return this;
    }

    @ApiModelProperty(value="Fully described deposit rates for this account based on the equivalent structure in Product Reference")
    public List<BankingProductDepositRate> getDepositRates() {
        return this.depositRates;
    }

    public void setDepositRates(List<BankingProductDepositRate> depositRates) {
        this.depositRates = depositRates;
    }

    public BankingAccountDetail features(List<BankingAccountProductFeature> features) {
        this.features = features;
        return this;
    }

    public BankingAccountDetail addItem(BankingAccountProductFeature featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList();
        }
        this.features.add(featuresItem);
        return this;
    }

    @ApiModelProperty(value="Array of features of the account based on the equivalent structure in Product Reference with the following additional field")
    public List<BankingAccountProductFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<BankingAccountProductFeature> features) {
        this.features = features;
    }

    public BankingAccountDetail fees(List<BankingProductFee> fees) {
        this.fees = fees;
        return this;
    }

    public BankingAccountDetail addItem(BankingProductFee feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList();
        }
        this.fees.add(feesItem);
        return this;
    }

    @ApiModelProperty(value="Fees and charges applicable to the account based on the equivalent structure in Product Reference")
    public List<BankingProductFee> getFees() {
        return this.fees;
    }

    public void setFees(List<BankingProductFee> fees) {
        this.fees = fees;
    }

    public BankingAccountDetail lendingRate(String lendingRate) {
        this.lendingRate = lendingRate;
        return this;
    }

    @ApiModelProperty(value="The current rate to calculate interest payable being applied to lending balances as it stands at the time of the API call")
    public String getLendingRate() {
        return this.lendingRate;
    }

    public void setLendingRate(String lendingRate) {
        this.lendingRate = lendingRate;
    }

    public BankingAccountDetail lendingRates(List<BankingProductLendingRate> lendingRates) {
        this.lendingRates = lendingRates;
        return this;
    }

    public BankingAccountDetail addItem(BankingProductLendingRate lendingRatesItem) {
        if (this.lendingRates == null) {
            this.lendingRates = new ArrayList();
        }
        this.lendingRates.add(lendingRatesItem);
        return this;
    }

    @ApiModelProperty(value="Fully described deposit rates for this account based on the equivalent structure in Product Reference")
    public List<BankingProductLendingRate> getLendingRates() {
        return this.lendingRates;
    }

    public void setLendingRates(List<BankingProductLendingRate> lendingRates) {
        this.lendingRates = lendingRates;
    }

    public BankingAccountDetail loan(BankingLoanAccount loan) {
        this.loan = loan;
        return this;
    }

    @ApiModelProperty
    public BankingLoanAccount getLoan() {
        return this.loan;
    }

    public void setLoan(BankingLoanAccount loan) {
        this.loan = loan;
    }

    public BankingAccountDetail specificAccountUType(SpecificAccountUType specificAccountUType) {
        this.specificAccountUType = specificAccountUType;
        return this;
    }

    @ApiModelProperty
    public SpecificAccountUType getSpecificAccountUType() {
        return this.specificAccountUType;
    }

    public void setSpecificAccountUType(SpecificAccountUType specificAccountUType) {
        this.specificAccountUType = specificAccountUType;
    }

    public BankingAccountDetail termDeposit(List<BankingTermDepositAccount> termDeposit) {
        this.termDeposit = termDeposit;
        return this;
    }

    @ApiModelProperty
    public List<BankingTermDepositAccount> getTermDeposit() {
        return this.termDeposit;
    }

    public void setTermDeposit(List<BankingTermDepositAccount> termDeposit) {
        this.termDeposit = termDeposit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingAccountDetail bankingAccountDetail = (BankingAccountDetail)o;
        return Objects.equals(this.accountNumber, bankingAccountDetail.accountNumber) && Objects.equals(this.addresses, bankingAccountDetail.addresses) && Objects.equals(this.bsb, bankingAccountDetail.bsb) && Objects.equals(this.bundleName, bankingAccountDetail.bundleName) && Objects.equals(this.creditCard, bankingAccountDetail.creditCard) && Objects.equals(this.depositRate, bankingAccountDetail.depositRate) && Objects.equals(this.depositRates, bankingAccountDetail.depositRates) && Objects.equals(this.features, bankingAccountDetail.features) && Objects.equals(this.fees, bankingAccountDetail.fees) && Objects.equals(this.lendingRate, bankingAccountDetail.lendingRate) && Objects.equals(this.lendingRates, bankingAccountDetail.lendingRates) && Objects.equals(this.loan, bankingAccountDetail.loan) && Objects.equals(this.specificAccountUType, bankingAccountDetail.specificAccountUType) && Objects.equals(this.termDeposit, bankingAccountDetail.termDeposit) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.accountNumber, this.addresses, this.bsb, this.bundleName, this.creditCard, this.depositRate, this.depositRates, this.features, this.fees, this.lendingRate, this.lendingRates, this.loan, this.specificAccountUType, this.termDeposit, super.hashCode());
    }

    public String toString() {
        return "class BankingAccountDetail {\n   accountId: " + this.toIndentedString((Object)this.getAccountId()) + "\n   creationDate: " + this.toIndentedString((Object)this.getCreationDate()) + "\n   displayName: " + this.toIndentedString((Object)this.getDisplayName()) + "\n   isOwned: " + this.toIndentedString((Object)this.getIsOwned()) + "\n   maskedNumber: " + this.toIndentedString((Object)this.getMaskedNumber()) + "\n   nickname: " + this.toIndentedString((Object)this.getNickname()) + "\n   openStatus: " + this.toIndentedString((Object)this.getOpenStatus()) + "\n   productCategory: " + this.toIndentedString((Object)this.getProductCategory()) + "\n   productName: " + this.toIndentedString((Object)this.getProductName()) + "\n   accountNumber: " + this.toIndentedString((Object)this.accountNumber) + "\n   addresses: " + this.toIndentedString((Object)this.addresses) + "\n   bsb: " + this.toIndentedString((Object)this.bsb) + "\n   bundleName: " + this.toIndentedString((Object)this.bundleName) + "\n   creditCard: " + this.toIndentedString((Object)this.creditCard) + "\n   depositRate: " + this.toIndentedString((Object)this.depositRate) + "\n   depositRates: " + this.toIndentedString((Object)this.depositRates) + "\n   features: " + this.toIndentedString((Object)this.features) + "\n   fees: " + this.toIndentedString((Object)this.fees) + "\n   lendingRate: " + this.toIndentedString((Object)this.lendingRate) + "\n   lendingRates: " + this.toIndentedString((Object)this.lendingRates) + "\n   loan: " + this.toIndentedString((Object)this.loan) + "\n   specificAccountUType: " + this.toIndentedString((Object)this.specificAccountUType) + "\n   termDeposit: " + this.toIndentedString((Object)this.termDeposit) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

