/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
@Table(name="BankingAccount")
public class BankingAccount {
    @Id
    private String accountId;
    @JsonIgnore
    private String userId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate creationDate;
    private String displayName;
    @Transient
    private Boolean isOwned;
    private String maskedNumber;
    private String nickname;
    private OpenStatus openStatus;
    private BankingProductCategory productCategory;
    private String productName;

    public BankingAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID of the account adhering to the standards for ID permanence")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankingAccount userId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public BankingAccount creationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="Date that the account was created (if known)")
    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public BankingAccount displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(required=true, value="The display name of the account as defined by the bank. This should not incorporate account numbers or PANs. If it does the values should be masked according to the rules of the MaskedAccountString common type.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public BankingAccount isOwned(Boolean isOwned) {
        this.isOwned = isOwned;
        return this;
    }

    @ApiModelProperty(value="Flag indicating that the customer associated with the authorisation is an owner of the account. Does not indicate sole ownership, however. If not present then 'true' is assumed")
    public Boolean getIsOwned() {
        return this.isOwned;
    }

    public void setIsOwned(Boolean isOwned) {
        this.isOwned = isOwned;
    }

    public BankingAccount maskedNumber(String maskedNumber) {
        this.maskedNumber = maskedNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="A masked version of the account. Whether BSB/Account Number, Credit Card PAN or another number")
    public String getMaskedNumber() {
        return this.maskedNumber;
    }

    public void setMaskedNumber(String maskedNumber) {
        this.maskedNumber = maskedNumber;
    }

    public BankingAccount nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(value="A customer supplied nick name for the account")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public BankingAccount openStatus(OpenStatus openStatus) {
        this.openStatus = openStatus;
        return this;
    }

    @ApiModelProperty
    public OpenStatus getOpenStatus() {
        return this.openStatus;
    }

    public void setOpenStatus(OpenStatus openStatus) {
        this.openStatus = openStatus;
    }

    public BankingAccount productCategory(BankingProductCategory productCategory) {
        this.productCategory = productCategory;
        return this;
    }

    @ApiModelProperty(required=true)
    public BankingProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(BankingProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public BankingAccount productName(String productName) {
        this.productName = productName;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the account as defined by the account holder (akin to model number for the account)")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingAccount bankingAccount = (BankingAccount)o;
        return Objects.equals(this.accountId, bankingAccount.accountId) && Objects.equals(this.userId, bankingAccount.userId) && Objects.equals(this.creationDate, bankingAccount.creationDate) && Objects.equals(this.displayName, bankingAccount.displayName) && Objects.equals(this.isOwned, bankingAccount.isOwned) && Objects.equals(this.maskedNumber, bankingAccount.maskedNumber) && Objects.equals(this.nickname, bankingAccount.nickname) && Objects.equals(this.openStatus, bankingAccount.openStatus) && Objects.equals(this.productCategory, bankingAccount.productCategory) && Objects.equals(this.productName, bankingAccount.productName);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.userId, this.creationDate, this.displayName, this.isOwned, this.maskedNumber, this.nickname, this.openStatus, this.productCategory, this.productName);
    }

    public String toString() {
        return "class BankingAccount {\n   accountId: " + this.toIndentedString((Object)this.accountId) + "\n   userId: " + this.toIndentedString((Object)this.userId) + "\n   creationDate: " + this.toIndentedString((Object)this.creationDate) + "\n   displayName: " + this.toIndentedString((Object)this.displayName) + "\n   isOwned: " + this.toIndentedString((Object)this.isOwned) + "\n   maskedNumber: " + this.toIndentedString((Object)this.maskedNumber) + "\n   nickname: " + this.toIndentedString((Object)this.nickname) + "\n   openStatus: " + this.toIndentedString((Object)this.openStatus) + "\n   productCategory: " + this.toIndentedString((Object)this.productCategory) + "\n   productName: " + this.toIndentedString((Object)this.productName) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

