/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.ApiControllerBase;
import au.org.consumerdatastandards.holder.api.BankingAccountsApi;
import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingAccountDetail;
import au.org.consumerdatastandards.holder.model.BankingBalance;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.BankingTransactionDetail;
import au.org.consumerdatastandards.holder.model.Links;
import au.org.consumerdatastandards.holder.model.MetaPaginated;
import au.org.consumerdatastandards.holder.model.ParamAccountOpenStatus;
import au.org.consumerdatastandards.holder.model.ParamProductCategory;
import au.org.consumerdatastandards.holder.model.RequestAccountIds;
import au.org.consumerdatastandards.holder.model.ResponseBankingAccountById;
import au.org.consumerdatastandards.holder.model.ResponseBankingAccountList;
import au.org.consumerdatastandards.holder.model.ResponseBankingAccountListData;
import au.org.consumerdatastandards.holder.model.ResponseBankingAccountsBalanceById;
import au.org.consumerdatastandards.holder.model.ResponseBankingAccountsBalanceList;
import au.org.consumerdatastandards.holder.model.ResponseBankingAccountsBalanceListData;
import au.org.consumerdatastandards.holder.model.ResponseBankingTransactionById;
import au.org.consumerdatastandards.holder.model.ResponseBankingTransactionList;
import au.org.consumerdatastandards.holder.model.ResponseBankingTransactionListData;
import au.org.consumerdatastandards.holder.service.BankingAccountService;
import au.org.consumerdatastandards.holder.service.BankingTransactionService;
import au.org.consumerdatastandards.holder.util.WebUtil;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Controller
@RequestMapping(value={"${openapi.consumerDataStandards.base-path:/cds-au/v1}"})
public class BankingAccountsApiController
extends ApiControllerBase
implements BankingAccountsApi {
    private final BankingAccountService accountService;
    private final BankingTransactionService transactionService;
    private final NativeWebRequest request;

    @Autowired
    public BankingAccountsApiController(NativeWebRequest request, BankingAccountService accountService, BankingTransactionService transactionService) {
        this.request = request;
        this.accountService = accountService;
        this.transactionService = transactionService;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<ResponseBankingAccountById> getAccountDetail(String accountId, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        BankingAccountDetail bankingAccountDetail = this.accountService.getBankingAccountDetail(accountId);
        if (bankingAccountDetail == null) {
            return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        ResponseBankingAccountById responseBankingAccountById = new ResponseBankingAccountById();
        responseBankingAccountById.setData(bankingAccountDetail);
        responseBankingAccountById.setLinks(new Links().self(WebUtil.getOriginalUrl((NativeWebRequest)this.request)));
        return new ResponseEntity((Object)responseBankingAccountById, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingTransactionById> getTransactionDetail(String accountId, String transactionId, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        BankingTransactionDetail transactionDetail = this.transactionService.getBankingTransactionDetail(transactionId);
        if (transactionDetail == null) {
            return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        ResponseBankingTransactionById responseBankingTransactionById = new ResponseBankingTransactionById();
        responseBankingTransactionById.setData(transactionDetail);
        responseBankingTransactionById.setLinks(new Links().self(WebUtil.getOriginalUrl((NativeWebRequest)this.request)));
        return new ResponseEntity((Object)responseBankingTransactionById, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingTransactionList> getTransactions(String accountId, BigDecimal maxAmount, BigDecimal minAmount, OffsetDateTime newestTime, OffsetDateTime oldestTime, Integer page, Integer pageSize, String text, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        Page transactionPage = this.transactionService.findTransactions(accountId, maxAmount, minAmount, newestTime, oldestTime, text, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        ResponseBankingTransactionListData listData = new ResponseBankingTransactionListData();
        listData.setTransactions(transactionPage.getContent());
        ResponseBankingTransactionList responseBankingTransactionList = new ResponseBankingTransactionList();
        responseBankingTransactionList.setData(listData);
        responseBankingTransactionList.setLinks(this.getLinkData(this.request, transactionPage, actualPage, actualPageSize));
        responseBankingTransactionList.setMeta((MetaPaginated)this.getTxMetaData(transactionPage, false));
        return new ResponseEntity((Object)responseBankingTransactionList, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingAccountList> listAccounts(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        BankingAccount bankingAccount = new BankingAccount();
        if (openStatus != null && !openStatus.equals((Object)ParamAccountOpenStatus.ALL)) {
            bankingAccount.setOpenStatus(BankingAccount.OpenStatus.valueOf((String)openStatus.name()));
        }
        if (productCategory != null) {
            bankingAccount.setProductCategory(BankingProductCategory.valueOf((String)productCategory.name()));
        }
        Page accountPage = this.accountService.findBankingAccountsLike(isOwned, bankingAccount, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        ResponseBankingAccountListData listData = new ResponseBankingAccountListData();
        listData.setAccounts(accountPage.getContent());
        ResponseBankingAccountList responseBankingAccountList = new ResponseBankingAccountList();
        responseBankingAccountList.setData(listData);
        responseBankingAccountList.setLinks(this.getLinkData(this.request, accountPage, actualPage, actualPageSize));
        responseBankingAccountList.setMeta(this.getMetaData(accountPage));
        return new ResponseEntity((Object)responseBankingAccountList, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingAccountsBalanceById> getBalance(String accountId, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        BankingBalance balance = this.accountService.getBankingBalance(accountId);
        if (balance == null) {
            return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        ResponseBankingAccountsBalanceById responseBankingAccountsBalanceById = new ResponseBankingAccountsBalanceById();
        responseBankingAccountsBalanceById.setData(balance);
        responseBankingAccountsBalanceById.setLinks(new Links().self(WebUtil.getOriginalUrl((NativeWebRequest)this.request)));
        return new ResponseEntity((Object)responseBankingAccountsBalanceById, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingAccountsBalanceList> listBalancesBulk(Boolean isOwned, ParamAccountOpenStatus paramOpenStatus, ParamProductCategory paramProductCategory, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        BankingAccount.OpenStatus openStatus = null;
        if (paramOpenStatus != null && !ParamAccountOpenStatus.ALL.equals((Object)paramOpenStatus)) {
            openStatus = BankingAccount.OpenStatus.valueOf((String)paramOpenStatus.name());
        }
        BankingProductCategory productCategory = null;
        if (paramProductCategory != null) {
            productCategory = BankingProductCategory.valueOf((String)paramProductCategory.name());
        }
        Page balancePage = this.accountService.getBankingBalances(isOwned, productCategory, openStatus, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getBalanceListResponse(headers, actualPage, actualPageSize, balancePage);
    }

    public ResponseEntity<ResponseBankingAccountsBalanceList> listBalancesSpecificAccounts(RequestAccountIds accountIds, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        Page balancePage = this.accountService.getBankingBalances(accountIds.getData().getAccountIds(), (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getBalanceListResponse(headers, actualPage, actualPageSize, balancePage);
    }

    private ResponseEntity<ResponseBankingAccountsBalanceList> getBalanceListResponse(HttpHeaders headers, Integer actualPage, Integer actualPageSize, Page<BankingBalance> balancePage) {
        ResponseBankingAccountsBalanceListData listData = new ResponseBankingAccountsBalanceListData();
        listData.setBalances(balancePage.getContent());
        ResponseBankingAccountsBalanceList responseBankingAccountsBalanceList = new ResponseBankingAccountsBalanceList();
        responseBankingAccountsBalanceList.setData(listData);
        responseBankingAccountsBalanceList.setLinks(this.getLinkData(this.request, balancePage, actualPage, actualPageSize));
        responseBankingAccountsBalanceList.setMeta(this.getMetaData(balancePage));
        return new ResponseEntity((Object)responseBankingAccountsBalanceList, (MultiValueMap)headers, HttpStatus.OK);
    }
}

