/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.model.BankingProduct;
import au.org.consumerdatastandards.holder.model.BankingProductDetail;
import au.org.consumerdatastandards.holder.model.ParamEffective;
import au.org.consumerdatastandards.holder.repository.BankingProductDetailsRepository;
import au.org.consumerdatastandards.holder.repository.BankingProductsRepository;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BankingProductsService {
    private final BankingProductsRepository productsRepository;
    private final BankingProductDetailsRepository productDetailsRepository;
    private static final Logger LOG = LogManager.getLogger(BankingProductsService.class);

    @Autowired
    public BankingProductsService(BankingProductsRepository productsRepository, BankingProductDetailsRepository productDetailsRepository) {
        this.productsRepository = productsRepository;
        this.productDetailsRepository = productDetailsRepository;
    }

    public Page<BankingProduct> findProductsLike(ParamEffective effective, BankingProduct bankingProduct, Pageable pageable) {
        LOG.debug("Retrieve database products matching inputs of effective {}, BankingProduct specified as {} with Paging content specified as {}", (Object)effective, (Object)bankingProduct, (Object)pageable);
        return this.productsRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (ParamEffective.CURRENT.equals((Object)effective) || effective == null) {
                OffsetDateTime now = OffsetDateTime.now();
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.lessThanOrEqualTo((Expression)root.get("effectiveFrom"), (Comparable)now)}));
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("effectiveTo"), (Comparable)now)}));
            } else if (ParamEffective.FUTURE.equals((Object)effective)) {
                OffsetDateTime now = OffsetDateTime.now();
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.greaterThan((Expression)root.get("effectiveFrom"), (Comparable)now)}));
            }
            if (bankingProduct.getProductCategory() != null) {
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("productCategory"), (Object)bankingProduct.getProductCategory())}));
            }
            if (bankingProduct.getLastUpdated() != null) {
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("lastUpdated"), (Comparable)bankingProduct.getLastUpdated())}));
            }
            if (!StringUtils.isEmpty((Object)bankingProduct.getBrand())) {
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.like((Expression)root.get("brand"), "%" + bankingProduct.getBrand() + "%")}));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }

    public BankingProductDetail getProductDetail(String productId) {
        LOG.debug("Retrieving detailed product information from database for Product ID of {}", (Object)productId);
        Optional byId = this.productDetailsRepository.findById((Object)productId);
        return byId.orElse(null);
    }
}

