/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.configuration;

import au.org.consumerdatastandards.holder.configuration.OpenAPIDocumentationConfig;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Date;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class OpenAPIDocumentationConfig {
    ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Consumer Data Standards").description("API sets created by the Australian Consumer Data Standards to meet the needs of the Consumer Data Right").license("MIT License").licenseUrl("https://opensource.org/licenses/MIT").termsOfServiceUrl("").version("1").contact(new Contact("Data61", "https://consumerdatastandards.org.au", "cdr-data61@csiro.au")).build();
    }

    @Bean
    public Docket customImplementation(ServletContext servletContext, @Value(value="${openapi.consumerdatastandards.base-path:/cds-au/v1}") String basePath) {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.basePackage((String)"au.org.consumerdatastandards.holder.api")).build().pathProvider((PathProvider)new BasePathAwareRelativePathProvider(this, servletContext, basePath)).directModelSubstitute(LocalDate.class, java.sql.Date.class).directModelSubstitute(OffsetDateTime.class, Date.class).apiInfo(this.apiInfo());
    }
}

