/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.BankingProductsApi;
import au.org.consumerdatastandards.holder.model.BankingProduct;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.Links;
import au.org.consumerdatastandards.holder.model.LinksPaginated;
import au.org.consumerdatastandards.holder.model.Meta;
import au.org.consumerdatastandards.holder.model.MetaPaginated;
import au.org.consumerdatastandards.holder.model.ParamEffective;
import au.org.consumerdatastandards.holder.model.ResponseBankingProductById;
import au.org.consumerdatastandards.holder.model.ResponseBankingProductList;
import au.org.consumerdatastandards.holder.model.ResponseBankingProductListData;
import au.org.consumerdatastandards.holder.service.BankingProductsService;
import au.org.consumerdatastandards.holder.util.WebUtil;
import java.time.OffsetDateTime;
import java.util.Optional;
import javax.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

@Controller
@RequestMapping(value={"${openapi.consumerDataStandards.base-path:/cds-au/v1}"})
public class BankingProductsApiController
implements BankingProductsApi {
    private final BankingProductsService service;
    private static final Logger LOGGER = LogManager.getLogger(BankingProductsApiController.class);
    private final NativeWebRequest request;

    @Autowired
    public BankingProductsApiController(NativeWebRequest request, BankingProductsService service) {
        this.request = request;
        this.service = service;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<ResponseBankingProductById> getProductDetail(String productId) {
        LOGGER.info("Retrieving Detailed Product Information for {}", (Object)productId);
        if (!WebUtil.hasSupportedVersion((NativeWebRequest)this.request)) {
            LOGGER.error("Unsupported version requested, minimum version specified is {}, maximum version specified is {}, current version is {}", (Object)WebUtil.getMinimumVersion((NativeWebRequest)this.request), (Object)WebUtil.getMaximumVersion((NativeWebRequest)this.request), (Object)WebUtil.getCurrentVersion());
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).build();
        }
        HttpHeaders headers = WebUtil.processHeaders((NativeWebRequest)this.request);
        ResponseBankingProductById responseProductById = new ResponseBankingProductById();
        responseProductById.setData(this.service.getProductDetail(productId));
        responseProductById.setLinks(new Links());
        responseProductById.getLinks().setSelf(WebUtil.getOriginalUrl((NativeWebRequest)this.request));
        responseProductById.setMeta(new Meta());
        if (responseProductById.getData() == null) {
            LOGGER.error("Unable to located product id {} in repository", (Object)productId);
            return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        LOGGER.info("Found product id of {} and returning formatted response", (Object)productId);
        LOGGER.info("Retrieved Product id {} with effectiveFrom: {}, effectiveTo: {}, lastUpdated: {}", (Object)productId, (Object)responseProductById.getData().getEffectiveFrom(), (Object)responseProductById.getData().getEffectiveTo(), (Object)responseProductById.getData().getLastUpdated());
        LOGGER.debug("Detail product response is: {}", (Object)responseProductById);
        return new ResponseEntity((Object)responseProductById, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingProductList> listProducts(@Valid ParamEffective effective, @Valid OffsetDateTime updatedSince, @Valid String brand, @Valid BankingProductCategory productCategory, @Valid Integer page, @Valid Integer pageSize) {
        LOGGER.info("Initiating product list call with supplied input of effective from {}, updated since {}, brand of {}, product category of {} for page {} with page size of {}", (Object)effective, (Object)updatedSince, (Object)brand, (Object)productCategory, (Object)page, (Object)pageSize);
        if (!WebUtil.hasSupportedVersion((NativeWebRequest)this.request)) {
            LOGGER.error("Unsupported version requested, minimum version specified is {}, maximum version specified is {}, current version is {}", (Object)WebUtil.getMinimumVersion((NativeWebRequest)this.request), (Object)WebUtil.getMaximumVersion((NativeWebRequest)this.request), (Object)WebUtil.getCurrentVersion());
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).build();
        }
        HttpHeaders headers = WebUtil.processHeaders((NativeWebRequest)this.request);
        if (!this.validatePageInputs(page, pageSize)) {
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        BankingProduct bankingProduct = new BankingProduct();
        bankingProduct.setLastUpdated(updatedSince);
        bankingProduct.setBrand(brand);
        if (productCategory != null) {
            bankingProduct.setProductCategory(BankingProductCategory.valueOf((String)productCategory.name()));
        }
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        Page productsPage = this.service.findProductsLike(effective, bankingProduct, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        LOGGER.info("Returning basic product listing page {} of {} (page size of {}) using filters of effective {}, updated since {}, brand {}, product category of {}", (Object)actualPage, (Object)productsPage.getTotalPages(), (Object)actualPageSize, (Object)effective, (Object)updatedSince, (Object)brand, (Object)productCategory);
        ResponseBankingProductListData listData = new ResponseBankingProductListData();
        listData.setProducts(productsPage.getContent());
        LOGGER.info("Products Page data set to isFirst: {}, isLast: {}", (Object)productsPage.isFirst(), (Object)productsPage.isLast());
        LinksPaginated linkData = new LinksPaginated();
        linkData.setSelf(WebUtil.getOriginalUrl((NativeWebRequest)this.request));
        if (productsPage.getTotalPages() == 0) {
            linkData.setFirst(null);
            linkData.setLast(null);
        } else {
            linkData.setFirst(WebUtil.getPaginatedLink((NativeWebRequest)this.request, (Integer)1, (Integer)actualPageSize));
            linkData.setLast(WebUtil.getPaginatedLink((NativeWebRequest)this.request, (Integer)productsPage.getTotalPages(), (Integer)actualPageSize));
        }
        if (productsPage.hasPrevious()) {
            linkData.setPrev(WebUtil.getPaginatedLink((NativeWebRequest)this.request, (Integer)(actualPage - 1), (Integer)actualPageSize));
        }
        if (productsPage.hasNext()) {
            linkData.setPrev(WebUtil.getPaginatedLink((NativeWebRequest)this.request, (Integer)(actualPage + 1), (Integer)actualPageSize));
        }
        MetaPaginated metaData = new MetaPaginated();
        metaData.setTotalPages(Integer.valueOf(productsPage.getTotalPages()));
        metaData.setTotalRecords(Integer.valueOf((int)productsPage.getTotalElements()));
        ResponseBankingProductList responseProductList = new ResponseBankingProductList();
        responseProductList.setData(listData);
        responseProductList.setLinks(linkData);
        responseProductList.setMeta(metaData);
        LOGGER.debug("Product listing raw response payload is: {}", (Object)responseProductList);
        return new ResponseEntity((Object)responseProductList, (MultiValueMap)headers, HttpStatus.OK);
    }

    private Integer getPagingValue(@Valid Integer page, int defaultValue) {
        LOGGER.debug("Loading page {} with default value of {}", (Object)page, (Object)defaultValue);
        return page != null && page > 0 ? page : defaultValue;
    }

    private boolean validatePageInputs(Integer page, Integer pageSize) {
        return !(page != null && page < 1 || pageSize != null && pageSize < 1);
    }
}

