/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.util;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebUtil {
    static final String V = "x-v";
    static final String MIN_V = "x-min-v";
    static final Integer CURRENT_VERSION = 1;
    static final String CORRELATION_ID = "x-Correlation-Id";
    static final String FAPI_INTERACTION_ID = "x-fapi-interaction-id";

    public static String getPaginatedLink(NativeWebRequest request, Integer page, Integer pageSize) {
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        String paginatedLink = WebUtil.getOriginalUrl((HttpServletRequest)servletRequest);
        String originalPage = servletRequest.getParameter("page");
        if (StringUtils.isEmpty((Object)originalPage)) {
            String pageParam = servletRequest.getParameterMap().isEmpty() ? "?page=" : "&page=";
            paginatedLink = paginatedLink + pageParam + page;
        } else {
            paginatedLink = paginatedLink.replace("page=" + originalPage, "page=" + page);
        }
        String originalPageSize = servletRequest.getParameter("page-size");
        paginatedLink = StringUtils.isEmpty((Object)originalPageSize) ? paginatedLink + "&page-size=" + pageSize : paginatedLink.replace("page-size=" + originalPageSize, "page-size=" + pageSize);
        return paginatedLink;
    }

    public static String getOriginalUrl(NativeWebRequest request) {
        return WebUtil.getOriginalUrl((HttpServletRequest)((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class)));
    }

    public static HttpHeaders processHeaders(NativeWebRequest request) {
        String fapiInteractionId;
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("content-type", "application/json");
        responseHeaders.set("x-v", WebUtil.getCurrentVersion().toString());
        String correlationId = request.getHeader("x-Correlation-Id");
        if (!StringUtils.isEmpty((Object)correlationId)) {
            responseHeaders.set("x-Correlation-Id", correlationId);
        }
        if (!StringUtils.isEmpty((Object)(fapiInteractionId = request.getHeader("x-fapi-interaction-id")))) {
            responseHeaders.set("x-fapi-interaction-id", fapiInteractionId);
        } else {
            responseHeaders.set("x-fapi-interaction-id", UUID.randomUUID().toString());
        }
        return responseHeaders;
    }

    private static String getOriginalUrl(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append("?").append(queryString).toString();
    }

    public static Integer getVersionHeader(NativeWebRequest request, String header) {
        Integer versionValue = null;
        String headerValue = request.getHeader(header);
        if (!StringUtils.isEmpty((Object)headerValue)) {
            try {
                versionValue = Integer.parseInt(headerValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return versionValue;
    }

    public static Integer getMaximumVersion(NativeWebRequest request) {
        return WebUtil.getVersionHeader((NativeWebRequest)request, (String)"x-v");
    }

    public static Integer getMinimumVersion(NativeWebRequest request) {
        return WebUtil.getVersionHeader((NativeWebRequest)request, (String)"x-min-v");
    }

    public static Integer getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static boolean hasSupportedVersion(NativeWebRequest request) {
        if (WebUtil.getMaximumVersion((NativeWebRequest)request) != null && WebUtil.getCurrentVersion() > WebUtil.getMaximumVersion((NativeWebRequest)request)) {
            return false;
        }
        return WebUtil.getMinimumVersion((NativeWebRequest)request) == null || WebUtil.getCurrentVersion() >= WebUtil.getMinimumVersion((NativeWebRequest)request);
    }
}

