/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.util;

import au.org.consumerdatastandards.holder.model.BankingProductDetail;
import au.org.consumerdatastandards.holder.repository.BankingProductDetailsRepository;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CdsDataLoader {
    private BankingProductDetailsRepository productDetailsRepository;
    private static final Logger LOG = LogManager.getLogger(CdsDataLoader.class);

    @Autowired
    public CdsDataLoader(BankingProductDetailsRepository productDetailsRepository) {
        this.productDetailsRepository = productDetailsRepository;
    }

    public void loadProducts(String fileOrFolder) throws IOException {
        File file = new File(fileOrFolder);
        if (file.isDirectory()) {
            File[] files;
            for (File oneFile : files = file.listFiles()) {
                this.loadProducts(oneFile.getAbsolutePath());
            }
        } else {
            LOG.info("Loading Product data from {}", (Object)file.getAbsolutePath());
            try {
                byte[] jsonData = Files.readAllBytes(Paths.get(file.getCanonicalPath(), new String[0]));
                ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
                BankingProductDetail productDetail = (BankingProductDetail)objectMapper.readValue(jsonData, BankingProductDetail.class);
                this.productDetailsRepository.save((Object)productDetail);
                LOG.info("Product Data loader saved the following to the database: \n{}", (Object)new String(jsonData));
            }
            catch (IOException e) {
                LOG.error("Product Data loader was unable to read {}, assuming this is fatal and throwing exception", (Object)file.getName());
                throw e;
            }
        }
    }
}

