/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder;

import au.org.consumerdatastandards.holder.HolderApplication;
import au.org.consumerdatastandards.holder.util.SwaggerJacksonModuleRegistrar;
import com.fasterxml.jackson.databind.Module;
import javax.servlet.Servlet;
import org.h2.server.web.WebServlet;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.UserDetailsServiceAutoConfiguration;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class, UserDetailsServiceAutoConfiguration.class})
@ComponentScan(basePackages={"au.org.consumerdatastandards.holder.api", "au.org.consumerdatastandards.holder.repository", "au.org.consumerdatastandards.holder.configuration", "au.org.consumerdatastandards.holder.service", "au.org.consumerdatastandards.holder.util"})
public class HolderApplication
implements CommandLineRunner {
    public void run(String ... arg0) {
        if (arg0.length > 0 && arg0[0].equals("exitcode")) {
            throw new ExitException(this);
        }
    }

    public static void main(String[] args) {
        new SpringApplication(new Class[]{HolderApplication.class}).run(args);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
    }

    @Bean
    public Module jsonNullableModule() {
        return new JsonNullableModule();
    }

    @Bean
    public ServletRegistrationBean<WebServlet> h2servletRegistration() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new WebServlet(), new String[0]);
        registration.addUrlMappings(new String[]{"/console/*"});
        return registration;
    }

    @Bean
    public SwaggerJacksonModuleRegistrar swaggerJacksonModuleRegistrar() {
        return new SwaggerJacksonModuleRegistrar();
    }
}

