/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiClient;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.model.CommonDiscoveryStatus;
import au.org.consumerdatastandards.client.model.ResponseDiscoveryOutagesList;
import ch.qos.logback.classic.Logger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.slf4j.LoggerFactory;

public class CommonDiscoveryAPI {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(CommonDiscoveryAPI.class);
    private ApiClient apiClient;

    public CommonDiscoveryAPI() {
        this(new ApiClient());
    }

    public CommonDiscoveryAPI(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getOutagesCall(ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/discovery/outages";
        LOGGER.trace("Building Call for getOutages with path: {}", (Object)path);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getOutagesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getOutagesCall(_callback);
    }

    public ResponseDiscoveryOutagesList getOutages() throws ApiException {
        LOGGER.trace("getOutages");
        ApiResponse<ResponseDiscoveryOutagesList> resp = this.getOutagesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ResponseDiscoveryOutagesList> getOutagesWithHttpInfo() throws ApiException {
        Call call = this.getOutagesValidateBeforeCall(null);
        Type returnType = new TypeToken<ResponseDiscoveryOutagesList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getOutagesAsync(ApiCallback<ResponseDiscoveryOutagesList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getOutages");
        Call call = this.getOutagesValidateBeforeCall(_callback);
        Type returnType = new TypeToken<ResponseDiscoveryOutagesList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call getStatusCall(ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/discovery/status";
        LOGGER.trace("Building Call for getStatus with path: {}", (Object)path);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getStatusValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getStatusCall(_callback);
    }

    public CommonDiscoveryStatus getStatus() throws ApiException {
        LOGGER.trace("getStatus");
        ApiResponse<CommonDiscoveryStatus> resp = this.getStatusWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<CommonDiscoveryStatus> getStatusWithHttpInfo() throws ApiException {
        Call call = this.getStatusValidateBeforeCall(null);
        Type returnType = new TypeToken<CommonDiscoveryStatus>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getStatusAsync(ApiCallback<CommonDiscoveryStatus> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getStatus");
        Call call = this.getStatusValidateBeforeCall(_callback);
        Type returnType = new TypeToken<CommonDiscoveryStatus>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }
}

