/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.api.ProtectedAPI;
import au.org.consumerdatastandards.client.model.ResponseCommonCustomer;
import au.org.consumerdatastandards.client.model.ResponseCommonCustomerDetail;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCustomerAPI
extends ProtectedAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonCustomerAPI.class);

    public Call getCustomerCall(ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/common/customer";
        LOGGER.trace("Building Call for getCustomer with path: {}", (Object)path);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getCustomerValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getCustomerCall(_callback);
    }

    public ResponseCommonCustomer getCustomer() throws ApiException {
        LOGGER.trace("getCustomer");
        ApiResponse<ResponseCommonCustomer> resp = this.getCustomerWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ResponseCommonCustomer> getCustomerWithHttpInfo() throws ApiException {
        Call call = this.getCustomerValidateBeforeCall(null);
        Type returnType = new TypeToken<ResponseCommonCustomer>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getCustomerAsync(ApiCallback<ResponseCommonCustomer> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getCustomer");
        Call call = this.getCustomerValidateBeforeCall(_callback);
        Type returnType = new TypeToken<ResponseCommonCustomer>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call getCustomerDetailCall(ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/common/customer/detail";
        LOGGER.trace("Building Call for getCustomerDetail with path: {}", (Object)path);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getCustomerDetailValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getCustomerDetailCall(_callback);
    }

    public ResponseCommonCustomerDetail getCustomerDetail() throws ApiException {
        LOGGER.trace("getCustomerDetail");
        ApiResponse<ResponseCommonCustomerDetail> resp = this.getCustomerDetailWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ResponseCommonCustomerDetail> getCustomerDetailWithHttpInfo() throws ApiException {
        Call call = this.getCustomerDetailValidateBeforeCall(null);
        Type returnType = new TypeToken<ResponseCommonCustomerDetail>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getCustomerDetailAsync(ApiCallback<ResponseCommonCustomerDetail> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getCustomerDetail");
        Call call = this.getCustomerDetailValidateBeforeCall(_callback);
        Type returnType = new TypeToken<ResponseCommonCustomerDetail>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }
}

