/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.api.ProtectedAPI;
import au.org.consumerdatastandards.client.model.RequestAccountIds;
import au.org.consumerdatastandards.client.model.ResponseBankingScheduledPaymentsList;
import ch.qos.logback.classic.Logger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.slf4j.LoggerFactory;

public class BankingScheduledPaymentsAPI
extends ProtectedAPI {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(BankingScheduledPaymentsAPI.class);

    public Call listScheduledPaymentsCall(String accountId, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/{accountId}/payments/scheduled".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId));
        LOGGER.trace("Building Call for listScheduledPayments with path: {}, accountId: {}, page: {}, page-size: {}", new Object[]{path, accountId, page, pageSize});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listScheduledPaymentsValidateBeforeCall(String accountId, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listScheduledPayments(Async)");
        }
        return this.listScheduledPaymentsCall(accountId, page, pageSize, _callback);
    }

    public ResponseBankingScheduledPaymentsList listScheduledPayments(String accountId, Integer page, Integer pageSize) throws ApiException {
        LOGGER.trace("listScheduledPayments with accountId: {}, page: {}, page-size: {}", new Object[]{accountId, page, pageSize});
        ApiResponse<ResponseBankingScheduledPaymentsList> resp = this.listScheduledPaymentsWithHttpInfo(accountId, page, pageSize);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingScheduledPaymentsList> listScheduledPaymentsWithHttpInfo(String accountId, Integer page, Integer pageSize) throws ApiException {
        Call call = this.listScheduledPaymentsValidateBeforeCall(accountId, page, pageSize, null);
        Type returnType = new TypeToken<ResponseBankingScheduledPaymentsList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listScheduledPaymentsAsync(String accountId, Integer page, Integer pageSize, ApiCallback<ResponseBankingScheduledPaymentsList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listScheduledPayments with accountId: {}, page: {}, page-size: {}", new Object[]{accountId, page, pageSize});
        Call call = this.listScheduledPaymentsValidateBeforeCall(accountId, page, pageSize, _callback);
        Type returnType = new TypeToken<ResponseBankingScheduledPaymentsList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listScheduledPaymentsSpecificAccountsCall(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/payments/scheduled";
        LOGGER.trace("Building Call for listScheduledPaymentsSpecificAccounts with path: {}, accountIds: {}, page: {}, page-size: {}", new Object[]{path, accountIds, page, pageSize});
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listScheduledPaymentsSpecificAccountsValidateBeforeCall(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        return this.listScheduledPaymentsSpecificAccountsCall(accountIds, page, pageSize, _callback);
    }

    public ResponseBankingScheduledPaymentsList listScheduledPaymentsSpecificAccounts(RequestAccountIds accountIds, Integer page, Integer pageSize) throws ApiException {
        LOGGER.trace("listScheduledPaymentsSpecificAccounts with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        ApiResponse<ResponseBankingScheduledPaymentsList> resp = this.listScheduledPaymentsSpecificAccountsWithHttpInfo(accountIds, page, pageSize);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingScheduledPaymentsList> listScheduledPaymentsSpecificAccountsWithHttpInfo(RequestAccountIds accountIds, Integer page, Integer pageSize) throws ApiException {
        Call call = this.listScheduledPaymentsSpecificAccountsValidateBeforeCall(accountIds, page, pageSize, null);
        Type returnType = new TypeToken<ResponseBankingScheduledPaymentsList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listScheduledPaymentsSpecificAccountsAsync(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback<ResponseBankingScheduledPaymentsList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listScheduledPaymentsSpecificAccounts with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        Call call = this.listScheduledPaymentsSpecificAccountsValidateBeforeCall(accountIds, page, pageSize, _callback);
        Type returnType = new TypeToken<ResponseBankingScheduledPaymentsList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }
}

