/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiClient;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.model.ParamProductCategory;
import au.org.consumerdatastandards.client.model.ResponseBankingProductById;
import au.org.consumerdatastandards.client.model.ResponseBankingProductList;
import ch.qos.logback.classic.Logger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.slf4j.LoggerFactory;

public class BankingProductsAPI {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(BankingProductsAPI.class);
    private ApiClient apiClient;

    public BankingProductsAPI() {
        this(new ApiClient());
    }

    public BankingProductsAPI(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getProductDetailCall(String productId, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/products/{productId}".replaceAll("\\{productId\\}", this.apiClient.escapeString(productId));
        LOGGER.trace("Building Call for getProductDetail with path: {}, productId: {}", (Object)path, (Object)productId);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getProductDetailValidateBeforeCall(String productId, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProductDetail(Async)");
        }
        return this.getProductDetailCall(productId, _callback);
    }

    public ResponseBankingProductById getProductDetail(String productId) throws ApiException {
        LOGGER.trace("getProductDetail with productId: {}", (Object)productId);
        ApiResponse<ResponseBankingProductById> resp = this.getProductDetailWithHttpInfo(productId);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingProductById> getProductDetailWithHttpInfo(String productId) throws ApiException {
        Call call = this.getProductDetailValidateBeforeCall(productId, null);
        Type returnType = new TypeToken<ResponseBankingProductById>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getProductDetailAsync(String productId, ApiCallback<ResponseBankingProductById> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getProductDetail with productId: {}", (Object)productId);
        Call call = this.getProductDetailValidateBeforeCall(productId, _callback);
        Type returnType = new TypeToken<ResponseBankingProductById>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listProductsCall(String brand, ParamEffective effective, Integer page, Integer pageSize, ParamProductCategory productCategory, OffsetDateTime updatedSince, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/products";
        LOGGER.trace("Building Call for listProducts with path: {}, brand: {}, effective: {}, page: {}, page-size: {}, product-category: {}, updated-since: {}", new Object[]{path, brand, effective, page, pageSize, productCategory, updatedSince});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "brand", brand);
        this.addQueryParam(queryParams, "effective", (Object)effective);
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        this.addQueryParam(queryParams, "product-category", (Object)productCategory);
        this.addQueryParam(queryParams, "updated-since", updatedSince);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listProductsValidateBeforeCall(String brand, ParamEffective effective, Integer page, Integer pageSize, ParamProductCategory productCategory, OffsetDateTime updatedSince, ApiCallback _callback) throws ApiException {
        return this.listProductsCall(brand, effective, page, pageSize, productCategory, updatedSince, _callback);
    }

    public ResponseBankingProductList listProducts(String brand, ParamEffective effective, Integer page, Integer pageSize, ParamProductCategory productCategory, OffsetDateTime updatedSince) throws ApiException {
        LOGGER.trace("listProducts with brand: {}, effective: {}, page: {}, page-size: {}, product-category: {}, updated-since: {}", new Object[]{brand, effective, page, pageSize, productCategory, updatedSince});
        ApiResponse<ResponseBankingProductList> resp = this.listProductsWithHttpInfo(brand, effective, page, pageSize, productCategory, updatedSince);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingProductList> listProductsWithHttpInfo(String brand, ParamEffective effective, Integer page, Integer pageSize, ParamProductCategory productCategory, OffsetDateTime updatedSince) throws ApiException {
        Call call = this.listProductsValidateBeforeCall(brand, effective, page, pageSize, productCategory, updatedSince, null);
        Type returnType = new TypeToken<ResponseBankingProductList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listProductsAsync(String brand, ParamEffective effective, Integer page, Integer pageSize, ParamProductCategory productCategory, OffsetDateTime updatedSince, ApiCallback<ResponseBankingProductList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listProducts with brand: {}, effective: {}, page: {}, page-size: {}, product-category: {}, updated-since: {}", new Object[]{brand, effective, page, pageSize, productCategory, updatedSince});
        Call call = this.listProductsValidateBeforeCall(brand, effective, page, pageSize, productCategory, updatedSince, _callback);
        Type returnType = new TypeToken<ResponseBankingProductList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }

    public static enum ParamEffective {
        ALL,
        CURRENT,
        FUTURE;

    }
}

