/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.api.ProtectedAPI;
import au.org.consumerdatastandards.client.model.ResponseBankingPayeeById;
import au.org.consumerdatastandards.client.model.ResponseBankingPayeeList;
import ch.qos.logback.classic.Logger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.slf4j.LoggerFactory;

public class BankingPayeesAPI
extends ProtectedAPI {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(BankingPayeesAPI.class);

    public Call getPayeeDetailCall(String payeeId, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/payees/{payeeId}".replaceAll("\\{payeeId\\}", this.apiClient.escapeString(payeeId));
        LOGGER.trace("Building Call for getPayeeDetail with path: {}, payeeId: {}", (Object)path, (Object)payeeId);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getPayeeDetailValidateBeforeCall(String payeeId, ApiCallback _callback) throws ApiException {
        if (payeeId == null) {
            throw new ApiException("Missing the required parameter 'payeeId' when calling getPayeeDetail(Async)");
        }
        return this.getPayeeDetailCall(payeeId, _callback);
    }

    public ResponseBankingPayeeById getPayeeDetail(String payeeId) throws ApiException {
        LOGGER.trace("getPayeeDetail with payeeId: {}", (Object)payeeId);
        ApiResponse<ResponseBankingPayeeById> resp = this.getPayeeDetailWithHttpInfo(payeeId);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingPayeeById> getPayeeDetailWithHttpInfo(String payeeId) throws ApiException {
        Call call = this.getPayeeDetailValidateBeforeCall(payeeId, null);
        Type returnType = new TypeToken<ResponseBankingPayeeById>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getPayeeDetailAsync(String payeeId, ApiCallback<ResponseBankingPayeeById> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getPayeeDetail with payeeId: {}", (Object)payeeId);
        Call call = this.getPayeeDetailValidateBeforeCall(payeeId, _callback);
        Type returnType = new TypeToken<ResponseBankingPayeeById>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listPayeesCall(Integer page, Integer pageSize, ParamType type, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/payees";
        LOGGER.trace("Building Call for listPayees with path: {}, page: {}, page-size: {}, type: {}", new Object[]{path, page, pageSize, type});
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        this.addQueryParam(queryParams, "type", (Object)type);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listPayeesValidateBeforeCall(Integer page, Integer pageSize, ParamType type, ApiCallback _callback) throws ApiException {
        return this.listPayeesCall(page, pageSize, type, _callback);
    }

    public ResponseBankingPayeeList listPayees(Integer page, Integer pageSize, ParamType type) throws ApiException {
        LOGGER.trace("listPayees with page: {}, page-size: {}, type: {}", new Object[]{page, pageSize, type});
        ApiResponse<ResponseBankingPayeeList> resp = this.listPayeesWithHttpInfo(page, pageSize, type);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingPayeeList> listPayeesWithHttpInfo(Integer page, Integer pageSize, ParamType type) throws ApiException {
        Call call = this.listPayeesValidateBeforeCall(page, pageSize, type, null);
        Type returnType = new TypeToken<ResponseBankingPayeeList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listPayeesAsync(Integer page, Integer pageSize, ParamType type, ApiCallback<ResponseBankingPayeeList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listPayees with page: {}, page-size: {}, type: {}", new Object[]{page, pageSize, type});
        Call call = this.listPayeesValidateBeforeCall(page, pageSize, type, _callback);
        Type returnType = new TypeToken<ResponseBankingPayeeList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }

    public static enum ParamType {
        ALL,
        BILLER,
        DOMESTIC,
        INTERNATIONAL;

    }
}

