/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.api.ProtectedAPI;
import au.org.consumerdatastandards.client.model.ParamAccountOpenStatus;
import au.org.consumerdatastandards.client.model.ParamProductCategory;
import au.org.consumerdatastandards.client.model.RequestAccountIds;
import au.org.consumerdatastandards.client.model.ResponseBankingDirectDebitAuthorisationList;
import ch.qos.logback.classic.Logger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.slf4j.LoggerFactory;

public class BankingDirectDebitsAPI
extends ProtectedAPI {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(BankingDirectDebitsAPI.class);

    public Call listDirectDebitsCall(String accountId, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/{accountId}/direct-debits".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId));
        LOGGER.trace("Building Call for listDirectDebits with path: {}, accountId: {}, page: {}, page-size: {}", new Object[]{path, accountId, page, pageSize});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listDirectDebitsValidateBeforeCall(String accountId, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listDirectDebits(Async)");
        }
        return this.listDirectDebitsCall(accountId, page, pageSize, _callback);
    }

    public ResponseBankingDirectDebitAuthorisationList listDirectDebits(String accountId, Integer page, Integer pageSize) throws ApiException {
        LOGGER.trace("listDirectDebits with accountId: {}, page: {}, page-size: {}", new Object[]{accountId, page, pageSize});
        ApiResponse<ResponseBankingDirectDebitAuthorisationList> resp = this.listDirectDebitsWithHttpInfo(accountId, page, pageSize);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingDirectDebitAuthorisationList> listDirectDebitsWithHttpInfo(String accountId, Integer page, Integer pageSize) throws ApiException {
        Call call = this.listDirectDebitsValidateBeforeCall(accountId, page, pageSize, null);
        Type returnType = new TypeToken<ResponseBankingDirectDebitAuthorisationList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listDirectDebitsAsync(String accountId, Integer page, Integer pageSize, ApiCallback<ResponseBankingDirectDebitAuthorisationList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listDirectDebits with accountId: {}, page: {}, page-size: {}", new Object[]{accountId, page, pageSize});
        Call call = this.listDirectDebitsValidateBeforeCall(accountId, page, pageSize, _callback);
        Type returnType = new TypeToken<ResponseBankingDirectDebitAuthorisationList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listDirectDebitsBulkCall(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/balances";
        LOGGER.trace("Building Call for listDirectDebits with path: {}, is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{path, isOwned, openStatus, page, pageSize, productCategory});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "is-owned", isOwned);
        this.addQueryParam(queryParams, "open-status", (Object)openStatus);
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        this.addQueryParam(queryParams, "product-category", (Object)productCategory);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listDirectDebitsBulkValidateBeforeCall(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback _callback) throws ApiException {
        return this.listDirectDebitsBulkCall(isOwned, openStatus, page, pageSize, productCategory, _callback);
    }

    public ResponseBankingDirectDebitAuthorisationList listDirectDebitsBulk(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory) throws ApiException {
        LOGGER.trace("listDirectDebits with is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{isOwned, openStatus, page, pageSize, productCategory});
        ApiResponse<ResponseBankingDirectDebitAuthorisationList> resp = this.listDirectDebitsBulkWithHttpInfo(isOwned, openStatus, page, pageSize, productCategory);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingDirectDebitAuthorisationList> listDirectDebitsBulkWithHttpInfo(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory) throws ApiException {
        Call call = this.listDirectDebitsBulkValidateBeforeCall(isOwned, openStatus, page, pageSize, productCategory, null);
        Type returnType = new TypeToken<ResponseBankingDirectDebitAuthorisationList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listDirectDebitsBulkAsync(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback<ResponseBankingDirectDebitAuthorisationList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listDirectDebits with is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{isOwned, openStatus, page, pageSize, productCategory});
        Call call = this.listDirectDebitsBulkValidateBeforeCall(isOwned, openStatus, page, pageSize, productCategory, _callback);
        Type returnType = new TypeToken<ResponseBankingDirectDebitAuthorisationList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listDirectDebitsSpecificAccountsCall(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        RequestAccountIds postBody = accountIds;
        String path = "/banking/accounts/direct-debits";
        LOGGER.trace("Building Call for listDirectDebitsSpecificAccounts with path: {}, accountIds: {}, page: {}, page-size: {}", new Object[]{path, accountIds, page, pageSize});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listDirectDebitsSpecificAccountsValidateBeforeCall(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        return this.listDirectDebitsSpecificAccountsCall(accountIds, page, pageSize, _callback);
    }

    public ResponseBankingDirectDebitAuthorisationList listDirectDebitsSpecificAccounts(RequestAccountIds accountIds, Integer page, Integer pageSize) throws ApiException {
        LOGGER.trace("listDirectDebitsSpecificAccounts with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        ApiResponse<ResponseBankingDirectDebitAuthorisationList> resp = this.listDirectDebitsSpecificAccountsWithHttpInfo(accountIds, page, pageSize);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingDirectDebitAuthorisationList> listDirectDebitsSpecificAccountsWithHttpInfo(RequestAccountIds accountIds, Integer page, Integer pageSize) throws ApiException {
        Call call = this.listDirectDebitsSpecificAccountsValidateBeforeCall(accountIds, page, pageSize, null);
        Type returnType = new TypeToken<ResponseBankingDirectDebitAuthorisationList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listDirectDebitsSpecificAccountsAsync(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback<ResponseBankingDirectDebitAuthorisationList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listDirectDebitsSpecificAccounts with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        Call call = this.listDirectDebitsSpecificAccountsValidateBeforeCall(accountIds, page, pageSize, _callback);
        Type returnType = new TypeToken<ResponseBankingDirectDebitAuthorisationList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }
}

