/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.api.ProtectedAPI;
import au.org.consumerdatastandards.client.model.ParamAccountOpenStatus;
import au.org.consumerdatastandards.client.model.ParamProductCategory;
import au.org.consumerdatastandards.client.model.RequestAccountIds;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountById;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountList;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountsBalanceById;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountsBalanceList;
import au.org.consumerdatastandards.client.model.ResponseBankingTransactionById;
import au.org.consumerdatastandards.client.model.ResponseBankingTransactionList;
import ch.qos.logback.classic.Logger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.slf4j.LoggerFactory;

public class BankingAccountsAPI
extends ProtectedAPI {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(BankingAccountsAPI.class);

    public Call getAccountDetailCall(String accountId, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/{accountId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId));
        LOGGER.trace("Building Call for getAccountDetail with path: {}, accountId: {}", (Object)path, (Object)accountId);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getAccountDetailValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountDetail(Async)");
        }
        return this.getAccountDetailCall(accountId, _callback);
    }

    public ResponseBankingAccountById getAccountDetail(String accountId) throws ApiException {
        LOGGER.trace("getAccountDetail with accountId: {}", (Object)accountId);
        ApiResponse<ResponseBankingAccountById> resp = this.getAccountDetailWithHttpInfo(accountId);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingAccountById> getAccountDetailWithHttpInfo(String accountId) throws ApiException {
        Call call = this.getAccountDetailValidateBeforeCall(accountId, null);
        Type returnType = new TypeToken<ResponseBankingAccountById>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getAccountDetailAsync(String accountId, ApiCallback<ResponseBankingAccountById> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getAccountDetail with accountId: {}", (Object)accountId);
        Call call = this.getAccountDetailValidateBeforeCall(accountId, _callback);
        Type returnType = new TypeToken<ResponseBankingAccountById>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call getTransactionDetailCall(String accountId, String transactionId, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/{accountId}/transactions/{transactionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId)).replaceAll("\\{transactionId\\}", this.apiClient.escapeString(transactionId));
        LOGGER.trace("Building Call for getTransactionDetail with path: {}, accountId: {}, transactionId: {}", new Object[]{path, accountId, transactionId});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getTransactionDetailValidateBeforeCall(String accountId, String transactionId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getTransactionDetail(Async)");
        }
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling getTransactionDetail(Async)");
        }
        return this.getTransactionDetailCall(accountId, transactionId, _callback);
    }

    public ResponseBankingTransactionById getTransactionDetail(String accountId, String transactionId) throws ApiException {
        LOGGER.trace("getTransactionDetail with accountId: {}, transactionId: {}", (Object)accountId, (Object)transactionId);
        ApiResponse<ResponseBankingTransactionById> resp = this.getTransactionDetailWithHttpInfo(accountId, transactionId);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingTransactionById> getTransactionDetailWithHttpInfo(String accountId, String transactionId) throws ApiException {
        Call call = this.getTransactionDetailValidateBeforeCall(accountId, transactionId, null);
        Type returnType = new TypeToken<ResponseBankingTransactionById>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getTransactionDetailAsync(String accountId, String transactionId, ApiCallback<ResponseBankingTransactionById> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getTransactionDetail with accountId: {}, transactionId: {}", (Object)accountId, (Object)transactionId);
        Call call = this.getTransactionDetailValidateBeforeCall(accountId, transactionId, _callback);
        Type returnType = new TypeToken<ResponseBankingTransactionById>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call getTransactionsCall(String accountId, String maxAmount, String minAmount, OffsetDateTime newestTime, OffsetDateTime oldestTime, Integer page, Integer pageSize, String text, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/{accountId}/transactions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId));
        LOGGER.trace("Building Call for getTransactions with path: {}, accountId: {}, max-amount: {}, min-amount: {}, newest-time: {}, oldest-time: {}, page: {}, page-size: {}, text: {}", new Object[]{path, accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "max-amount", maxAmount);
        this.addQueryParam(queryParams, "min-amount", minAmount);
        this.addQueryParam(queryParams, "newest-time", newestTime);
        this.addQueryParam(queryParams, "oldest-time", oldestTime);
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        this.addQueryParam(queryParams, "text", text);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call getTransactionsValidateBeforeCall(String accountId, String maxAmount, String minAmount, OffsetDateTime newestTime, OffsetDateTime oldestTime, Integer page, Integer pageSize, String text, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getTransactions(Async)");
        }
        return this.getTransactionsCall(accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text, _callback);
    }

    public ResponseBankingTransactionList getTransactions(String accountId, String maxAmount, String minAmount, OffsetDateTime newestTime, OffsetDateTime oldestTime, Integer page, Integer pageSize, String text) throws ApiException {
        LOGGER.trace("getTransactions with accountId: {}, max-amount: {}, min-amount: {}, newest-time: {}, oldest-time: {}, page: {}, page-size: {}, text: {}", new Object[]{accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text});
        ApiResponse<ResponseBankingTransactionList> resp = this.getTransactionsWithHttpInfo(accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingTransactionList> getTransactionsWithHttpInfo(String accountId, String maxAmount, String minAmount, OffsetDateTime newestTime, OffsetDateTime oldestTime, Integer page, Integer pageSize, String text) throws ApiException {
        Call call = this.getTransactionsValidateBeforeCall(accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text, null);
        Type returnType = new TypeToken<ResponseBankingTransactionList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getTransactionsAsync(String accountId, String maxAmount, String minAmount, OffsetDateTime newestTime, OffsetDateTime oldestTime, Integer page, Integer pageSize, String text, ApiCallback<ResponseBankingTransactionList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously getTransactions with accountId: {}, max-amount: {}, min-amount: {}, newest-time: {}, oldest-time: {}, page: {}, page-size: {}, text: {}", new Object[]{accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text});
        Call call = this.getTransactionsValidateBeforeCall(accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text, _callback);
        Type returnType = new TypeToken<ResponseBankingTransactionList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listAccountsCall(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts";
        LOGGER.trace("Building Call for listAccounts with path: {}, is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{path, isOwned, openStatus, page, pageSize, productCategory});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "is-owned", isOwned);
        this.addQueryParam(queryParams, "open-status", (Object)openStatus);
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        this.addQueryParam(queryParams, "product-category", (Object)productCategory);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listAccountsValidateBeforeCall(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback _callback) throws ApiException {
        return this.listAccountsCall(isOwned, openStatus, page, pageSize, productCategory, _callback);
    }

    public ResponseBankingAccountList listAccounts(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory) throws ApiException {
        LOGGER.trace("listAccounts with is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{isOwned, openStatus, page, pageSize, productCategory});
        ApiResponse<ResponseBankingAccountList> resp = this.listAccountsWithHttpInfo(isOwned, openStatus, page, pageSize, productCategory);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingAccountList> listAccountsWithHttpInfo(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory) throws ApiException {
        Call call = this.listAccountsValidateBeforeCall(isOwned, openStatus, page, pageSize, productCategory, null);
        Type returnType = new TypeToken<ResponseBankingAccountList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listAccountsAsync(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback<ResponseBankingAccountList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listAccounts with is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{isOwned, openStatus, page, pageSize, productCategory});
        Call call = this.listAccountsValidateBeforeCall(isOwned, openStatus, page, pageSize, productCategory, _callback);
        Type returnType = new TypeToken<ResponseBankingAccountList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listBalanceCall(String accountId, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/{accountId}/balance".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId));
        LOGGER.trace("Building Call for listBalance with path: {}, accountId: {}", (Object)path, (Object)accountId);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listBalanceValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listBalance(Async)");
        }
        return this.listBalanceCall(accountId, _callback);
    }

    public ResponseBankingAccountsBalanceById listBalance(String accountId) throws ApiException {
        LOGGER.trace("listBalance with accountId: {}", (Object)accountId);
        ApiResponse<ResponseBankingAccountsBalanceById> resp = this.listBalanceWithHttpInfo(accountId);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingAccountsBalanceById> listBalanceWithHttpInfo(String accountId) throws ApiException {
        Call call = this.listBalanceValidateBeforeCall(accountId, null);
        Type returnType = new TypeToken<ResponseBankingAccountsBalanceById>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listBalanceAsync(String accountId, ApiCallback<ResponseBankingAccountsBalanceById> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listBalance with accountId: {}", (Object)accountId);
        Call call = this.listBalanceValidateBeforeCall(accountId, _callback);
        Type returnType = new TypeToken<ResponseBankingAccountsBalanceById>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listBalancesBulkCall(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback _callback) throws ApiException {
        Object postBody = null;
        String path = "/banking/accounts/balances";
        LOGGER.trace("Building Call for listBalancesBulk with path: {}, is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{path, isOwned, openStatus, page, pageSize, productCategory});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "is-owned", isOwned);
        this.addQueryParam(queryParams, "open-status", (Object)openStatus);
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        this.addQueryParam(queryParams, "product-category", (Object)productCategory);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "GET", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listBalancesBulkValidateBeforeCall(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback _callback) throws ApiException {
        return this.listBalancesBulkCall(isOwned, openStatus, page, pageSize, productCategory, _callback);
    }

    public ResponseBankingAccountsBalanceList listBalancesBulk(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory) throws ApiException {
        LOGGER.trace("listBalancesBulk with is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{isOwned, openStatus, page, pageSize, productCategory});
        ApiResponse<ResponseBankingAccountsBalanceList> resp = this.listBalancesBulkWithHttpInfo(isOwned, openStatus, page, pageSize, productCategory);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingAccountsBalanceList> listBalancesBulkWithHttpInfo(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory) throws ApiException {
        Call call = this.listBalancesBulkValidateBeforeCall(isOwned, openStatus, page, pageSize, productCategory, null);
        Type returnType = new TypeToken<ResponseBankingAccountsBalanceList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listBalancesBulkAsync(Boolean isOwned, ParamAccountOpenStatus openStatus, Integer page, Integer pageSize, ParamProductCategory productCategory, ApiCallback<ResponseBankingAccountsBalanceList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listBalancesBulk with is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{isOwned, openStatus, page, pageSize, productCategory});
        Call call = this.listBalancesBulkValidateBeforeCall(isOwned, openStatus, page, pageSize, productCategory, _callback);
        Type returnType = new TypeToken<ResponseBankingAccountsBalanceList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call listBalancesSpecificAccountsCall(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        RequestAccountIds postBody = accountIds;
        String path = "/banking/accounts/balances";
        LOGGER.trace("Building Call for listBalancesSpecificAccounts with path: {}, accountIds: {}, page: {}, page-size: {}", new Object[]{path, accountIds, page, pageSize});
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        this.addCdsProtectedApiHeaders(headerParams);
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, "POST", queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private Call listBalancesSpecificAccountsValidateBeforeCall(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback _callback) throws ApiException {
        return this.listBalancesSpecificAccountsCall(accountIds, page, pageSize, _callback);
    }

    public ResponseBankingAccountsBalanceList listBalancesSpecificAccounts(RequestAccountIds accountIds, Integer page, Integer pageSize) throws ApiException {
        LOGGER.trace("listBalancesSpecificAccounts with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        ApiResponse<ResponseBankingAccountsBalanceList> resp = this.listBalancesSpecificAccountsWithHttpInfo(accountIds, page, pageSize);
        return resp.getData();
    }

    public ApiResponse<ResponseBankingAccountsBalanceList> listBalancesSpecificAccountsWithHttpInfo(RequestAccountIds accountIds, Integer page, Integer pageSize) throws ApiException {
        Call call = this.listBalancesSpecificAccountsValidateBeforeCall(accountIds, page, pageSize, null);
        Type returnType = new TypeToken<ResponseBankingAccountsBalanceList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listBalancesSpecificAccountsAsync(RequestAccountIds accountIds, Integer page, Integer pageSize, ApiCallback<ResponseBankingAccountsBalanceList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously listBalancesSpecificAccounts with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        Call call = this.listBalancesSpecificAccountsValidateBeforeCall(accountIds, page, pageSize, _callback);
        Type returnType = new TypeToken<ResponseBankingAccountsBalanceList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }
}

