/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class CommonPerson {

    private String firstName;

    private String lastName;

    private OffsetDateTime lastUpdateTime;

    private List<String> middleNames;

    private String occupationCode;

    private String prefix;

    private String suffix;

    /**
     * For people with single names this field need not be present.  The single name should be in the lastName field
     * @return firstName
     */
    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /**
     * For people with single names the single name should be in this field
     * @return lastName
     */
    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /**
     * The date and time that this record was last updated by the customer.  If no update has occurred then this date should reflect the initial creation date for the data
     * @return lastUpdateTime
     */
    public OffsetDateTime getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    /**
     * Field is mandatory but array may be empty
     * @return middleNames
     */
    public List<String> getMiddleNames() {
        return middleNames;
    }

    public void setMiddleNames(List<String> middleNames) {
        this.middleNames = middleNames;
    }

    /**
     * Value is a valid [ANZCO v1.2](http://www.abs.gov.au/ANZSCO) Standard Occupation classification.
     * @return occupationCode
     */
    public String getOccupationCode() {
        return occupationCode;
    }

    public void setOccupationCode(String occupationCode) {
        this.occupationCode = occupationCode;
    }

    /**
     * Also known as title or salutation.  The prefix to the name (e.g. Mr, Mrs, Ms, Miss, Sir, etc)
     * @return prefix
     */
    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    /**
     * Used for a trailing suffix to the name (e.g. Jr)
     * @return suffix
     */
    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CommonPerson commonPerson = (CommonPerson) o;
        return Objects.equals(this.firstName, commonPerson.firstName) &&
            Objects.equals(this.lastName, commonPerson.lastName) &&
            Objects.equals(this.lastUpdateTime, commonPerson.lastUpdateTime) &&
            Objects.equals(this.middleNames, commonPerson.middleNames) &&
            Objects.equals(this.occupationCode, commonPerson.occupationCode) &&
            Objects.equals(this.prefix, commonPerson.prefix) &&
            Objects.equals(this.suffix, commonPerson.suffix);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            firstName,
            lastName,
            lastUpdateTime,
            middleNames,
            occupationCode,
            prefix,
            suffix);
    }

    @Override
    public String toString() {
        return "class CommonPerson {\n" +
            "   firstName: " + toIndentedString(firstName) + "\n" + 
            "   lastName: " + toIndentedString(lastName) + "\n" + 
            "   lastUpdateTime: " + toIndentedString(lastUpdateTime) + "\n" + 
            "   middleNames: " + toIndentedString(middleNames) + "\n" + 
            "   occupationCode: " + toIndentedString(occupationCode) + "\n" + 
            "   prefix: " + toIndentedString(prefix) + "\n" + 
            "   suffix: " + toIndentedString(suffix) + "\n" + 
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
