/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;

public class CommonOrganisation {

    public enum OrganisationType {
        COMPANY,
        GOVERNMENT_ENTITY,
        OTHER,
        PARTNERSHIP,
        SOLE_TRADER,
        TRUST
    }

    private String abn;

    private String acn;

    private String agentFirstName;

    private String agentLastName;

    private String agentRole;

    private String businessName;

    private LocalDate establishmentDate;

    private String industryCode;

    private Boolean isACNCRegistered;

    private OffsetDateTime lastUpdateTime;

    private String legalName;

    private OrganisationType organisationType;

    private String registeredCountry;

    private String shortName;

    /**
     * Australian Business Number for the organisation
     * @return abn
     */
    public String getAbn() {
        return abn;
    }

    public void setAbn(String abn) {
        this.abn = abn;
    }

    /**
     * Australian Company Number for the organisation. Required only if an ACN is applicable for the organisation type
     * @return acn
     */
    public String getAcn() {
        return acn;
    }

    public void setAcn(String acn) {
        this.acn = acn;
    }

    /**
     * The first name of the individual providing access on behalf of the organisation. For people with single names this field need not be present.  The single name should be in the lastName field
     * @return agentFirstName
     */
    public String getAgentFirstName() {
        return agentFirstName;
    }

    public void setAgentFirstName(String agentFirstName) {
        this.agentFirstName = agentFirstName;
    }

    /**
     * The last name of the individual providing access on behalf of the organisation. For people with single names the single name should be in this field
     * @return agentLastName
     */
    public String getAgentLastName() {
        return agentLastName;
    }

    public void setAgentLastName(String agentLastName) {
        this.agentLastName = agentLastName;
    }

    /**
     * The role of the individual identified as the agent who is providing authorisation.  Expected to be used for display.  Default to “Unspecified” if the role is not known
     * @return agentRole
     */
    public String getAgentRole() {
        return agentRole;
    }

    public void setAgentRole(String agentRole) {
        this.agentRole = agentRole;
    }

    /**
     * Name of the organisation
     * @return businessName
     */
    public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    /**
     * The date the organisation described was established
     * @return establishmentDate
     */
    public LocalDate getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(LocalDate establishmentDate) {
        this.establishmentDate = establishmentDate;
    }

    /**
     * [ANZSIC (2006)](http://www.abs.gov.au/anzsic) code for the organisation.
     * @return industryCode
     */
    public String getIndustryCode() {
        return industryCode;
    }

    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    /**
     * True if registered with the ACNC.  False if not. Absent or null if not confirmed.
     * @return isACNCRegistered
     */
    public Boolean getIsACNCRegistered() {
        return isACNCRegistered;
    }

    public void setIsACNCRegistered(Boolean isACNCRegistered) {
        this.isACNCRegistered = isACNCRegistered;
    }

    /**
     * The date and time that this record was last updated by the customer. If no update has occurred then this date should reflect the initial creation date for the data
     * @return lastUpdateTime
     */
    public OffsetDateTime getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    /**
     * Legal name, if different to the business name
     * @return legalName
     */
    public String getLegalName() {
        return legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    /**
     * Get organisationType
     * @return organisationType
     */
    public OrganisationType getOrganisationType() {
        return organisationType;
    }

    public void setOrganisationType(OrganisationType organisationType) {
        this.organisationType = organisationType;
    }

    /**
     * Enumeration with values from [ISO 3166 Alpha-3](https://www.iso.org/iso-3166-country-codes.html) country codes.  Assumed to be AUS if absent
     * @return registeredCountry
     */
    public String getRegisteredCountry() {
        return registeredCountry;
    }

    public void setRegisteredCountry(String registeredCountry) {
        this.registeredCountry = registeredCountry;
    }

    /**
     * Short name used for communication, if  different to the business name
     * @return shortName
     */
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CommonOrganisation commonOrganisation = (CommonOrganisation) o;
        return Objects.equals(this.abn, commonOrganisation.abn) &&
            Objects.equals(this.acn, commonOrganisation.acn) &&
            Objects.equals(this.agentFirstName, commonOrganisation.agentFirstName) &&
            Objects.equals(this.agentLastName, commonOrganisation.agentLastName) &&
            Objects.equals(this.agentRole, commonOrganisation.agentRole) &&
            Objects.equals(this.businessName, commonOrganisation.businessName) &&
            Objects.equals(this.establishmentDate, commonOrganisation.establishmentDate) &&
            Objects.equals(this.industryCode, commonOrganisation.industryCode) &&
            Objects.equals(this.isACNCRegistered, commonOrganisation.isACNCRegistered) &&
            Objects.equals(this.lastUpdateTime, commonOrganisation.lastUpdateTime) &&
            Objects.equals(this.legalName, commonOrganisation.legalName) &&
            Objects.equals(this.organisationType, commonOrganisation.organisationType) &&
            Objects.equals(this.registeredCountry, commonOrganisation.registeredCountry) &&
            Objects.equals(this.shortName, commonOrganisation.shortName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            abn,
            acn,
            agentFirstName,
            agentLastName,
            agentRole,
            businessName,
            establishmentDate,
            industryCode,
            isACNCRegistered,
            lastUpdateTime,
            legalName,
            organisationType,
            registeredCountry,
            shortName);
    }

    @Override
    public String toString() {
        return "class CommonOrganisation {\n" +
            "   abn: " + toIndentedString(abn) + "\n" + 
            "   acn: " + toIndentedString(acn) + "\n" + 
            "   agentFirstName: " + toIndentedString(agentFirstName) + "\n" + 
            "   agentLastName: " + toIndentedString(agentLastName) + "\n" + 
            "   agentRole: " + toIndentedString(agentRole) + "\n" + 
            "   businessName: " + toIndentedString(businessName) + "\n" + 
            "   establishmentDate: " + toIndentedString(establishmentDate) + "\n" + 
            "   industryCode: " + toIndentedString(industryCode) + "\n" + 
            "   isACNCRegistered: " + toIndentedString(isACNCRegistered) + "\n" + 
            "   lastUpdateTime: " + toIndentedString(lastUpdateTime) + "\n" + 
            "   legalName: " + toIndentedString(legalName) + "\n" + 
            "   organisationType: " + toIndentedString(organisationType) + "\n" + 
            "   registeredCountry: " + toIndentedString(registeredCountry) + "\n" + 
            "   shortName: " + toIndentedString(shortName) + "\n" + 
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
