/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.time.OffsetDateTime;
import java.util.Objects;

public class BankingTransaction {

    public enum Status {
        PENDING,
        POSTED
    }

    public enum Type {
        DIRECT_DEBIT,
        FEE,
        INTEREST_CHARGED,
        INTEREST_PAID,
        OTHER,
        PAYMENT,
        TRANSFER_INCOMING,
        TRANSFER_OUTGOING
    }

    private String accountId;

    private String amount;

    private String apcaNumber;

    private String billerCode;

    private String billerName;

    private String crn;

    private String currency;

    private String description;

    private OffsetDateTime executionDateTime;

    private Boolean isDetailAvailable;

    private String merchantCategoryCode;

    private String merchantName;

    private OffsetDateTime postingDateTime;

    private String reference;

    private Status status;

    private String transactionId;

    private Type type;

    private OffsetDateTime valueDateTime;

    /**
     * ID of the account for which transactions are provided
     * @return accountId
     */
    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * The value of the transaction. Negative values mean money was outgoing from the account
     * @return amount
     */
    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    /**
     * 6 Digit APCA number for the initiating institution
     * @return apcaNumber
     */
    public String getApcaNumber() {
        return apcaNumber;
    }

    public void setApcaNumber(String apcaNumber) {
        this.apcaNumber = apcaNumber;
    }

    /**
     * BPAY Biller Code for the transaction (if available)
     * @return billerCode
     */
    public String getBillerCode() {
        return billerCode;
    }

    public void setBillerCode(String billerCode) {
        this.billerCode = billerCode;
    }

    /**
     * Name of the BPAY biller for the transaction (if available)
     * @return billerName
     */
    public String getBillerName() {
        return billerName;
    }

    public void setBillerName(String billerName) {
        this.billerName = billerName;
    }

    /**
     * BPAY CRN for the transaction (if available)
     * @return crn
     */
    public String getCrn() {
        return crn;
    }

    public void setCrn(String crn) {
        this.crn = crn;
    }

    /**
     * The currency for the transaction amount. AUD assumed if not present
     * @return currency
     */
    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * The transaction description as applied by the financial institution
     * @return description
     */
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The time the transaction was executed by the originating customer, if available
     * @return executionDateTime
     */
    public OffsetDateTime getExecutionDateTime() {
        return executionDateTime;
    }

    public void setExecutionDateTime(OffsetDateTime executionDateTime) {
        this.executionDateTime = executionDateTime;
    }

    /**
     * True if extended information is available using the transaction detail end point. False if extended data is not available
     * @return isDetailAvailable
     */
    public Boolean getIsDetailAvailable() {
        return isDetailAvailable;
    }

    public void setIsDetailAvailable(Boolean isDetailAvailable) {
        this.isDetailAvailable = isDetailAvailable;
    }

    /**
     * The merchant category code (or MCC) for an outgoing payment to a merchant
     * @return merchantCategoryCode
     */
    public String getMerchantCategoryCode() {
        return merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    /**
     * Name of the merchant for an outgoing payment to a merchant
     * @return merchantName
     */
    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    /**
     * The time the transaction was posted. This field is Mandatory if the transaction has status POSTED.  This is the time that appears on a standard statement
     * @return postingDateTime
     */
    public OffsetDateTime getPostingDateTime() {
        return postingDateTime;
    }

    public void setPostingDateTime(OffsetDateTime postingDateTime) {
        this.postingDateTime = postingDateTime;
    }

    /**
     * The reference for the transaction provided by the originating institution. Empty string if no data provided
     * @return reference
     */
    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    /**
     * Get status
     * @return status
     */
    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * A unique ID of the transaction adhering to the standards for ID permanence.  This is mandatory (through hashing if necessary) unless there are specific and justifiable technical reasons why a transaction cannot be uniquely identified for a particular account type
     * @return transactionId
     */
    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /**
     * Get type
     * @return type
     */
    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    /**
     * Date and time at which assets become available to the account owner in case of a credit entry, or cease to be available to the account owner in case of a debit transaction entry
     * @return valueDateTime
     */
    public OffsetDateTime getValueDateTime() {
        return valueDateTime;
    }

    public void setValueDateTime(OffsetDateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankingTransaction bankingTransaction = (BankingTransaction) o;
        return Objects.equals(this.accountId, bankingTransaction.accountId) &&
            Objects.equals(this.amount, bankingTransaction.amount) &&
            Objects.equals(this.apcaNumber, bankingTransaction.apcaNumber) &&
            Objects.equals(this.billerCode, bankingTransaction.billerCode) &&
            Objects.equals(this.billerName, bankingTransaction.billerName) &&
            Objects.equals(this.crn, bankingTransaction.crn) &&
            Objects.equals(this.currency, bankingTransaction.currency) &&
            Objects.equals(this.description, bankingTransaction.description) &&
            Objects.equals(this.executionDateTime, bankingTransaction.executionDateTime) &&
            Objects.equals(this.isDetailAvailable, bankingTransaction.isDetailAvailable) &&
            Objects.equals(this.merchantCategoryCode, bankingTransaction.merchantCategoryCode) &&
            Objects.equals(this.merchantName, bankingTransaction.merchantName) &&
            Objects.equals(this.postingDateTime, bankingTransaction.postingDateTime) &&
            Objects.equals(this.reference, bankingTransaction.reference) &&
            Objects.equals(this.status, bankingTransaction.status) &&
            Objects.equals(this.transactionId, bankingTransaction.transactionId) &&
            Objects.equals(this.type, bankingTransaction.type) &&
            Objects.equals(this.valueDateTime, bankingTransaction.valueDateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            accountId,
            amount,
            apcaNumber,
            billerCode,
            billerName,
            crn,
            currency,
            description,
            executionDateTime,
            isDetailAvailable,
            merchantCategoryCode,
            merchantName,
            postingDateTime,
            reference,
            status,
            transactionId,
            type,
            valueDateTime);
    }

    @Override
    public String toString() {
        return "class BankingTransaction {\n" +
            "   accountId: " + toIndentedString(accountId) + "\n" + 
            "   amount: " + toIndentedString(amount) + "\n" + 
            "   apcaNumber: " + toIndentedString(apcaNumber) + "\n" + 
            "   billerCode: " + toIndentedString(billerCode) + "\n" + 
            "   billerName: " + toIndentedString(billerName) + "\n" + 
            "   crn: " + toIndentedString(crn) + "\n" + 
            "   currency: " + toIndentedString(currency) + "\n" + 
            "   description: " + toIndentedString(description) + "\n" + 
            "   executionDateTime: " + toIndentedString(executionDateTime) + "\n" + 
            "   isDetailAvailable: " + toIndentedString(isDetailAvailable) + "\n" + 
            "   merchantCategoryCode: " + toIndentedString(merchantCategoryCode) + "\n" + 
            "   merchantName: " + toIndentedString(merchantName) + "\n" + 
            "   postingDateTime: " + toIndentedString(postingDateTime) + "\n" + 
            "   reference: " + toIndentedString(reference) + "\n" + 
            "   status: " + toIndentedString(status) + "\n" + 
            "   transactionId: " + toIndentedString(transactionId) + "\n" + 
            "   type: " + toIndentedString(type) + "\n" + 
            "   valueDateTime: " + toIndentedString(valueDateTime) + "\n" + 
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
