/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.time.LocalDate;
import java.util.Objects;
/**
 * Object containing the detail of the schedule for the payment
 */
public class BankingScheduledPaymentRecurrence {

    public enum RecurrenceUType {
        eventBased,
        intervalSchedule,
        lastWeekDay,
        onceOff
    }

    private BankingScheduledPaymentRecurrenceEventBased eventBased;

    private BankingScheduledPaymentRecurrenceIntervalSchedule intervalSchedule;

    private BankingScheduledPaymentRecurrenceLastWeekday lastWeekDay;

    private LocalDate nextPaymentDate;

    private BankingScheduledPaymentRecurrenceOnceOff onceOff;

    private RecurrenceUType recurrenceUType;

    /**
     * Get eventBased
     * @return eventBased
     */
    public BankingScheduledPaymentRecurrenceEventBased getEventBased() {
        return eventBased;
    }

    public void setEventBased(BankingScheduledPaymentRecurrenceEventBased eventBased) {
        this.eventBased = eventBased;
    }

    /**
     * Get intervalSchedule
     * @return intervalSchedule
     */
    public BankingScheduledPaymentRecurrenceIntervalSchedule getIntervalSchedule() {
        return intervalSchedule;
    }

    public void setIntervalSchedule(BankingScheduledPaymentRecurrenceIntervalSchedule intervalSchedule) {
        this.intervalSchedule = intervalSchedule;
    }

    /**
     * Get lastWeekDay
     * @return lastWeekDay
     */
    public BankingScheduledPaymentRecurrenceLastWeekday getLastWeekDay() {
        return lastWeekDay;
    }

    public void setLastWeekDay(BankingScheduledPaymentRecurrenceLastWeekday lastWeekDay) {
        this.lastWeekDay = lastWeekDay;
    }

    /**
     * The date of the next payment under the recurrence schedule
     * @return nextPaymentDate
     */
    public LocalDate getNextPaymentDate() {
        return nextPaymentDate;
    }

    public void setNextPaymentDate(LocalDate nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
    }

    /**
     * Get onceOff
     * @return onceOff
     */
    public BankingScheduledPaymentRecurrenceOnceOff getOnceOff() {
        return onceOff;
    }

    public void setOnceOff(BankingScheduledPaymentRecurrenceOnceOff onceOff) {
        this.onceOff = onceOff;
    }

    /**
     * Get recurrenceUType
     * @return recurrenceUType
     */
    public RecurrenceUType getRecurrenceUType() {
        return recurrenceUType;
    }

    public void setRecurrenceUType(RecurrenceUType recurrenceUType) {
        this.recurrenceUType = recurrenceUType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentRecurrence bankingScheduledPaymentRecurrence = (BankingScheduledPaymentRecurrence) o;
        return Objects.equals(this.eventBased, bankingScheduledPaymentRecurrence.eventBased) &&
            Objects.equals(this.intervalSchedule, bankingScheduledPaymentRecurrence.intervalSchedule) &&
            Objects.equals(this.lastWeekDay, bankingScheduledPaymentRecurrence.lastWeekDay) &&
            Objects.equals(this.nextPaymentDate, bankingScheduledPaymentRecurrence.nextPaymentDate) &&
            Objects.equals(this.onceOff, bankingScheduledPaymentRecurrence.onceOff) &&
            Objects.equals(this.recurrenceUType, bankingScheduledPaymentRecurrence.recurrenceUType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            eventBased,
            intervalSchedule,
            lastWeekDay,
            nextPaymentDate,
            onceOff,
            recurrenceUType);
    }

    @Override
    public String toString() {
        return "class BankingScheduledPaymentRecurrence {\n" +
            "   eventBased: " + toIndentedString(eventBased) + "\n" + 
            "   intervalSchedule: " + toIndentedString(intervalSchedule) + "\n" + 
            "   lastWeekDay: " + toIndentedString(lastWeekDay) + "\n" + 
            "   nextPaymentDate: " + toIndentedString(nextPaymentDate) + "\n" + 
            "   onceOff: " + toIndentedString(onceOff) + "\n" + 
            "   recurrenceUType: " + toIndentedString(recurrenceUType) + "\n" + 
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
