/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.util.List;
import java.util.Objects;

public class BankingScheduledPayment {

    public enum Status {
        ACTIVE,
        INACTIVE,
        SKIP
    }

    private BankingScheduledPaymentFrom from;

    private String nickname;

    private String payeeReference;

    private String payerReference;

    private List<BankingScheduledPaymentSet> paymentSet;

    private BankingScheduledPaymentRecurrence recurrence;

    private String scheduledPaymentId;

    private Status status;

    /**
     * Get from
     * @return from
     */
    public BankingScheduledPaymentFrom getFrom() {
        return from;
    }

    public void setFrom(BankingScheduledPaymentFrom from) {
        this.from = from;
    }

    /**
     * The short display name of the payee as provided by the customer
     * @return nickname
     */
    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    /**
     * The reference for the transaction that will be provided by the originating institution. Empty string if no data provided
     * @return payeeReference
     */
    public String getPayeeReference() {
        return payeeReference;
    }

    public void setPayeeReference(String payeeReference) {
        this.payeeReference = payeeReference;
    }

    /**
     * The reference for the transaction that will be used by the originating institution for the purposes of constructing a statement narrative on the payer’s account. Empty string if no data provided
     * @return payerReference
     */
    public String getPayerReference() {
        return payerReference;
    }

    public void setPayerReference(String payerReference) {
        this.payerReference = payerReference;
    }

    /**
     * Get paymentSet
     * @return paymentSet
     */
    public List<BankingScheduledPaymentSet> getPaymentSet() {
        return paymentSet;
    }

    public void setPaymentSet(List<BankingScheduledPaymentSet> paymentSet) {
        this.paymentSet = paymentSet;
    }

    /**
     * Get recurrence
     * @return recurrence
     */
    public BankingScheduledPaymentRecurrence getRecurrence() {
        return recurrence;
    }

    public void setRecurrence(BankingScheduledPaymentRecurrence recurrence) {
        this.recurrence = recurrence;
    }

    /**
     * A unique ID of the scheduled payment adhering to the standards for ID permanence
     * @return scheduledPaymentId
     */
    public String getScheduledPaymentId() {
        return scheduledPaymentId;
    }

    public void setScheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
    }

    /**
     * Get status
     * @return status
     */
    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPayment bankingScheduledPayment = (BankingScheduledPayment) o;
        return Objects.equals(this.from, bankingScheduledPayment.from) &&
            Objects.equals(this.nickname, bankingScheduledPayment.nickname) &&
            Objects.equals(this.payeeReference, bankingScheduledPayment.payeeReference) &&
            Objects.equals(this.payerReference, bankingScheduledPayment.payerReference) &&
            Objects.equals(this.paymentSet, bankingScheduledPayment.paymentSet) &&
            Objects.equals(this.recurrence, bankingScheduledPayment.recurrence) &&
            Objects.equals(this.scheduledPaymentId, bankingScheduledPayment.scheduledPaymentId) &&
            Objects.equals(this.status, bankingScheduledPayment.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            from,
            nickname,
            payeeReference,
            payerReference,
            paymentSet,
            recurrence,
            scheduledPaymentId,
            status);
    }

    @Override
    public String toString() {
        return "class BankingScheduledPayment {\n" +
            "   from: " + toIndentedString(from) + "\n" + 
            "   nickname: " + toIndentedString(nickname) + "\n" + 
            "   payeeReference: " + toIndentedString(payeeReference) + "\n" + 
            "   payerReference: " + toIndentedString(payerReference) + "\n" + 
            "   paymentSet: " + toIndentedString(paymentSet) + "\n" + 
            "   recurrence: " + toIndentedString(recurrence) + "\n" + 
            "   scheduledPaymentId: " + toIndentedString(scheduledPaymentId) + "\n" + 
            "   status: " + toIndentedString(status) + "\n" + 
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
