/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.util.List;
import java.util.Objects;

public class BankingProductDetail extends BankingProduct {

    private List<BankingProductBundle> bundles;

    private List<BankingProductConstraint> constraints;

    private List<BankingProductDepositRate> depositRates;

    private List<BankingProductEligibility> eligibility;

    private List<BankingProductFeature> features;

    private List<BankingProductFee> fees;

    private List<BankingProductLendingRate> lendingRates;

    /**
     * An array of bundles that this product participates in.  Each bundle is described by free form information but also by a list of product IDs of the other products that are included in the bundle.  It is assumed that the current product is included in the bundle also
     * @return bundles
     */
    public List<BankingProductBundle> getBundles() {
        return bundles;
    }

    public void setBundles(List<BankingProductBundle> bundles) {
        this.bundles = bundles;
    }

    /**
     * Constraints on the application for or operation of the product such as minimum balances or limit thresholds
     * @return constraints
     */
    public List<BankingProductConstraint> getConstraints() {
        return constraints;
    }

    public void setConstraints(List<BankingProductConstraint> constraints) {
        this.constraints = constraints;
    }

    /**
     * Interest rates available for deposits
     * @return depositRates
     */
    public List<BankingProductDepositRate> getDepositRates() {
        return depositRates;
    }

    public void setDepositRates(List<BankingProductDepositRate> depositRates) {
        this.depositRates = depositRates;
    }

    /**
     * Eligibility criteria for the product
     * @return eligibility
     */
    public List<BankingProductEligibility> getEligibility() {
        return eligibility;
    }

    public void setEligibility(List<BankingProductEligibility> eligibility) {
        this.eligibility = eligibility;
    }

    /**
     * Array of features available for the product
     * @return features
     */
    public List<BankingProductFeature> getFeatures() {
        return features;
    }

    public void setFeatures(List<BankingProductFeature> features) {
        this.features = features;
    }

    /**
     * Fees applicable for the product
     * @return fees
     */
    public List<BankingProductFee> getFees() {
        return fees;
    }

    public void setFees(List<BankingProductFee> fees) {
        this.fees = fees;
    }

    /**
     * Interest rates charged against lending balances
     * @return lendingRates
     */
    public List<BankingProductLendingRate> getLendingRates() {
        return lendingRates;
    }

    public void setLendingRates(List<BankingProductLendingRate> lendingRates) {
        this.lendingRates = lendingRates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankingProductDetail bankingProductDetail = (BankingProductDetail) o;
        return Objects.equals(this.bundles, bankingProductDetail.bundles) &&
            Objects.equals(this.constraints, bankingProductDetail.constraints) &&
            Objects.equals(this.depositRates, bankingProductDetail.depositRates) &&
            Objects.equals(this.eligibility, bankingProductDetail.eligibility) &&
            Objects.equals(this.features, bankingProductDetail.features) &&
            Objects.equals(this.fees, bankingProductDetail.fees) &&
            Objects.equals(this.lendingRates, bankingProductDetail.lendingRates) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            bundles,
            constraints,
            depositRates,
            eligibility,
            features,
            fees,
            lendingRates,
            super.hashCode());
    }

    @Override
    public String toString() {
        return "class BankingProductDetail {\n" +
            "   additionalInformation: " + toIndentedString(getAdditionalInformation()) + "\n" + 
            "   applicationUri: " + toIndentedString(getApplicationUri()) + "\n" + 
            "   brand: " + toIndentedString(getBrand()) + "\n" + 
            "   brandName: " + toIndentedString(getBrandName()) + "\n" + 
            "   description: " + toIndentedString(getDescription()) + "\n" + 
            "   effectiveFrom: " + toIndentedString(getEffectiveFrom()) + "\n" + 
            "   effectiveTo: " + toIndentedString(getEffectiveTo()) + "\n" + 
            "   isTailored: " + toIndentedString(getIsTailored()) + "\n" + 
            "   lastUpdated: " + toIndentedString(getLastUpdated()) + "\n" + 
            "   name: " + toIndentedString(getName()) + "\n" + 
            "   productCategory: " + toIndentedString(getProductCategory()) + "\n" + 
            "   productId: " + toIndentedString(getProductId()) + "\n" + 
            "   bundles: " + toIndentedString(bundles) + "\n" + 
            "   constraints: " + toIndentedString(constraints) + "\n" + 
            "   depositRates: " + toIndentedString(depositRates) + "\n" + 
            "   eligibility: " + toIndentedString(eligibility) + "\n" + 
            "   features: " + toIndentedString(features) + "\n" + 
            "   fees: " + toIndentedString(fees) + "\n" + 
            "   lendingRates: " + toIndentedString(lendingRates) + "\n" + 
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
