/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.util.List;
import java.util.Objects;

public class BankingAccountDetail extends BankingAccount {

    public enum SpecificAccountUType {
        creditCard,
        loan,
        termDeposit
    }

    private String accountNumber;

    private List<CommonPhysicalAddress> addresses;

    private String bsb;

    private String bundleName;

    private BankingCreditCardAccount creditCard;

    private String depositRate;

    private List<BankingProductDepositRate> depositRates;

    private List<Object> features;

    private List<BankingProductFee> fees;

    private String lendingRate;

    private List<BankingProductLendingRate> lendingRates;

    private BankingLoanAccount loan;

    private SpecificAccountUType specificAccountUType;

    private BankingTermDepositAccount termDeposit;

    /**
     * The unmasked account number for the account. Should not be supplied if the account number is a PAN requiring PCI compliance. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces
     * @return accountNumber
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /**
     * The addresses for the account to be used for correspondence
     * @return addresses
     */
    public List<CommonPhysicalAddress> getAddresses() {
        return addresses;
    }

    public void setAddresses(List<CommonPhysicalAddress> addresses) {
        this.addresses = addresses;
    }

    /**
     * The unmasked BSB for the account. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces
     * @return bsb
     */
    public String getBsb() {
        return bsb;
    }

    public void setBsb(String bsb) {
        this.bsb = bsb;
    }

    /**
     * Optional field to indicate if this account is part of a bundle that is providing additional benefit for to the customer
     * @return bundleName
     */
    public String getBundleName() {
        return bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    /**
     * Get creditCard
     * @return creditCard
     */
    public BankingCreditCardAccount getCreditCard() {
        return creditCard;
    }

    public void setCreditCard(BankingCreditCardAccount creditCard) {
        this.creditCard = creditCard;
    }

    /**
     * current rate to calculate interest earned being applied to deposit balances as it stands at the time of the API call
     * @return depositRate
     */
    public String getDepositRate() {
        return depositRate;
    }

    public void setDepositRate(String depositRate) {
        this.depositRate = depositRate;
    }

    /**
     * Fully described deposit rates for this account based on the equivalent structure in Product Reference
     * @return depositRates
     */
    public List<BankingProductDepositRate> getDepositRates() {
        return depositRates;
    }

    public void setDepositRates(List<BankingProductDepositRate> depositRates) {
        this.depositRates = depositRates;
    }

    /**
     * Array of features of the account based on the equivalent structure in Product Reference with the following additional field
     * @return features
     */
    public List<Object> getFeatures() {
        return features;
    }

    public void setFeatures(List<Object> features) {
        this.features = features;
    }

    /**
     * Fees and charges applicable to the account based on the equivalent structure in Product Reference
     * @return fees
     */
    public List<BankingProductFee> getFees() {
        return fees;
    }

    public void setFees(List<BankingProductFee> fees) {
        this.fees = fees;
    }

    /**
     * The current rate to calculate interest payable being applied to lending balances as it stands at the time of the API call
     * @return lendingRate
     */
    public String getLendingRate() {
        return lendingRate;
    }

    public void setLendingRate(String lendingRate) {
        this.lendingRate = lendingRate;
    }

    /**
     * Fully described deposit rates for this account based on the equivalent structure in Product Reference
     * @return lendingRates
     */
    public List<BankingProductLendingRate> getLendingRates() {
        return lendingRates;
    }

    public void setLendingRates(List<BankingProductLendingRate> lendingRates) {
        this.lendingRates = lendingRates;
    }

    /**
     * Get loan
     * @return loan
     */
    public BankingLoanAccount getLoan() {
        return loan;
    }

    public void setLoan(BankingLoanAccount loan) {
        this.loan = loan;
    }

    /**
     * Get specificAccountUType
     * @return specificAccountUType
     */
    public SpecificAccountUType getSpecificAccountUType() {
        return specificAccountUType;
    }

    public void setSpecificAccountUType(SpecificAccountUType specificAccountUType) {
        this.specificAccountUType = specificAccountUType;
    }

    /**
     * Get termDeposit
     * @return termDeposit
     */
    public BankingTermDepositAccount getTermDeposit() {
        return termDeposit;
    }

    public void setTermDeposit(BankingTermDepositAccount termDeposit) {
        this.termDeposit = termDeposit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BankingAccountDetail bankingAccountDetail = (BankingAccountDetail) o;
        return Objects.equals(this.accountNumber, bankingAccountDetail.accountNumber) &&
            Objects.equals(this.addresses, bankingAccountDetail.addresses) &&
            Objects.equals(this.bsb, bankingAccountDetail.bsb) &&
            Objects.equals(this.bundleName, bankingAccountDetail.bundleName) &&
            Objects.equals(this.creditCard, bankingAccountDetail.creditCard) &&
            Objects.equals(this.depositRate, bankingAccountDetail.depositRate) &&
            Objects.equals(this.depositRates, bankingAccountDetail.depositRates) &&
            Objects.equals(this.features, bankingAccountDetail.features) &&
            Objects.equals(this.fees, bankingAccountDetail.fees) &&
            Objects.equals(this.lendingRate, bankingAccountDetail.lendingRate) &&
            Objects.equals(this.lendingRates, bankingAccountDetail.lendingRates) &&
            Objects.equals(this.loan, bankingAccountDetail.loan) &&
            Objects.equals(this.specificAccountUType, bankingAccountDetail.specificAccountUType) &&
            Objects.equals(this.termDeposit, bankingAccountDetail.termDeposit) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            accountNumber,
            addresses,
            bsb,
            bundleName,
            creditCard,
            depositRate,
            depositRates,
            features,
            fees,
            lendingRate,
            lendingRates,
            loan,
            specificAccountUType,
            termDeposit,
            super.hashCode());
    }

    @Override
    public String toString() {
        return "class BankingAccountDetail {\n" +
            "   accountId: " + toIndentedString(getAccountId()) + "\n" + 
            "   creationDate: " + toIndentedString(getCreationDate()) + "\n" + 
            "   displayName: " + toIndentedString(getDisplayName()) + "\n" + 
            "   isOwned: " + toIndentedString(getIsOwned()) + "\n" + 
            "   maskedNumber: " + toIndentedString(getMaskedNumber()) + "\n" + 
            "   nickname: " + toIndentedString(getNickname()) + "\n" + 
            "   openStatus: " + toIndentedString(getOpenStatus()) + "\n" + 
            "   productCategory: " + toIndentedString(getProductCategory()) + "\n" + 
            "   productName: " + toIndentedString(getProductName()) + "\n" + 
            "   accountNumber: " + toIndentedString(accountNumber) + "\n" + 
            "   addresses: " + toIndentedString(addresses) + "\n" + 
            "   bsb: " + toIndentedString(bsb) + "\n" + 
            "   bundleName: " + toIndentedString(bundleName) + "\n" + 
            "   creditCard: " + toIndentedString(creditCard) + "\n" + 
            "   depositRate: " + toIndentedString(depositRate) + "\n" + 
            "   depositRates: " + toIndentedString(depositRates) + "\n" + 
            "   features: " + toIndentedString(features) + "\n" + 
            "   fees: " + toIndentedString(fees) + "\n" + 
            "   lendingRate: " + toIndentedString(lendingRate) + "\n" + 
            "   lendingRates: " + toIndentedString(lendingRates) + "\n" + 
            "   loan: " + toIndentedString(loan) + "\n" + 
            "   specificAccountUType: " + toIndentedString(specificAccountUType) + "\n" + 
            "   termDeposit: " + toIndentedString(termDeposit) + "\n" + 
            "}";
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
