/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.api;

import au.org.consumerdatastandards.client.ApiCallback;
import au.org.consumerdatastandards.client.ApiClient;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.ApiResponse;
import au.org.consumerdatastandards.client.Pair;
import au.org.consumerdatastandards.client.model.ParamEffective;
import au.org.consumerdatastandards.client.model.ParamProductCategory;
import au.org.consumerdatastandards.client.model.ResponseBankingProductById;
import au.org.consumerdatastandards.client.model.ResponseBankingProductList;
import ch.qos.logback.classic.Logger;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.slf4j.LoggerFactory;

public class BankingProductsAPI {
    private ApiClient apiClient;
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(BankingProductsAPI.class);

    public BankingProductsAPI() {
        this(new ApiClient());
    }

    public BankingProductsAPI(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call listProductsCall(ParamEffective effective, String updatedSince, String brand, ParamProductCategory productCategory, Integer page, Integer pageSize, ApiCallback<ResponseBankingProductList> _callback) throws ApiException {
        Object postBody = new Object();
        String path = "/banking/products";
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        this.addQueryParam(queryParams, "effective", (Object)effective);
        this.addQueryParam(queryParams, "updated-since", updatedSince);
        this.addQueryParam(queryParams, "brand", brand);
        this.addQueryParam(queryParams, "product-category", (Object)productCategory);
        this.addQueryParam(queryParams, "page", page);
        this.addQueryParam(queryParams, "page-size", pageSize);
        LOGGER.trace("Building Call for listProducts with path: {}, brand: {}, effective: {}, page: {}, page-size: {}, product-category: {}, updated-since: {}", new Object[]{path, brand, effective, page, pageSize, productCategory, updatedSince});
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        return this.buildCall(_callback, "GET", postBody, path, queryParams, collectionQueryParams, headerParams);
    }

    private Call listProductsValidateBeforeCall(ParamEffective effective, String updatedSince, String brand, ParamProductCategory productCategory, Integer page, Integer pageSize, ApiCallback<ResponseBankingProductList> _callback) throws ApiException {
        return this.listProductsCall(effective, updatedSince, brand, productCategory, page, pageSize, _callback);
    }

    public ResponseBankingProductList listProducts(ParamEffective effective, String updatedSince, String brand, ParamProductCategory productCategory, Integer page, Integer pageSize) throws ApiException {
        LOGGER.trace("Get Products with  brand: {}, effective: {}, page: {}, page-size: {}, product-category: {}, updated-since: {}", new Object[]{brand, effective, page, pageSize, productCategory, updatedSince});
        ApiResponse<ResponseBankingProductList> response = this.listProductsWithHttpInfo(effective, updatedSince, brand, productCategory, page, pageSize);
        return response.getData();
    }

    public ApiResponse<ResponseBankingProductList> listProductsWithHttpInfo(ParamEffective effective, String updatedSince, String brand, ParamProductCategory productCategory, Integer page, Integer pageSize) throws ApiException {
        LOGGER.trace("Preparing Get Products with HTTP Information using inputs of  brand: {}, effective: {}, page: {}, page-size: {}, product-category: {}, updated-since: {}", new Object[]{brand, effective, page, pageSize, productCategory, updatedSince});
        Call call = this.listProductsValidateBeforeCall(effective, updatedSince, brand, productCategory, page, pageSize, null);
        Type returnType = new TypeToken<ResponseBankingProductList>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call listProductsAsync(ParamEffective effective, String updatedSince, String brand, ParamProductCategory productCategory, Integer page, Integer pageSize, ApiCallback<ResponseBankingProductList> _callback) throws ApiException {
        LOGGER.trace("Asynchronously Get Products call using inputs of  brand: {}, effective: {}, page: {}, page-size: {}, product-category: {}, updated-since: {}", new Object[]{brand, effective, page, pageSize, productCategory, updatedSince});
        Call call = this.listProductsValidateBeforeCall(effective, updatedSince, brand, productCategory, page, pageSize, _callback);
        Type returnType = new TypeToken<ResponseBankingProductList>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    public Call getProductDetailCall(String productId, ApiCallback<ResponseBankingProductById> _callback) throws ApiException {
        Object postBody = new Object();
        String path = "/banking/products/{productId}";
        path = path.replaceAll("\\{productId}", this.apiClient.escapeString(productId));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        LOGGER.trace("Building Call for getProductDetail with path: {}, productId: {}", (Object)path, (Object)productId);
        ArrayList<Pair> collectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        return this.buildCall(_callback, "GET", postBody, path, queryParams, collectionQueryParams, headerParams);
    }

    private Call getProductDetailValidateBeforeCall(String productId, ApiCallback<ResponseBankingProductById> _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProductDetail(Async)");
        }
        return this.getProductDetailCall(productId, _callback);
    }

    public ResponseBankingProductById getProductDetail(String productId) throws ApiException {
        LOGGER.trace("Get Product Detail with  productId: {}", (Object)productId);
        ApiResponse<ResponseBankingProductById> response = this.getProductDetailWithHttpInfo(productId);
        return response.getData();
    }

    public ApiResponse<ResponseBankingProductById> getProductDetailWithHttpInfo(String productId) throws ApiException {
        LOGGER.trace("Preparing Get Product Detail with HTTP Information using inputs of  productId: {}", (Object)productId);
        Call call = this.getProductDetailValidateBeforeCall(productId, null);
        Type returnType = new TypeToken<ResponseBankingProductById>(){}.getType();
        return this.apiClient.execute(call, returnType);
    }

    public Call getProductDetailAsync(String productId, ApiCallback<ResponseBankingProductById> _callback) throws ApiException {
        LOGGER.trace("Asynchronously Get Product Detail call using inputs of  productId: {}", (Object)productId);
        Call call = this.getProductDetailValidateBeforeCall(productId, _callback);
        Type returnType = new TypeToken<ResponseBankingProductById>(){}.getType();
        this.apiClient.executeAsync(call, returnType, _callback);
        return call;
    }

    private Call buildCall(ApiCallback<?> _callback, String httpMethod, Object postBody, String path, List<Pair> queryParams, List<Pair> collectionQueryParams, Map<String, String> headerParams) throws ApiException {
        LOGGER.trace("Generic buildCall requested with http method: {}, post body: {}, var path: {}, query params: {}, collection query params: {}, header params: {}", new Object[]{httpMethod, postBody, path, queryParams, collectionQueryParams, headerParams});
        String[] authNames = new String[]{};
        return this.apiClient.buildCall(path, httpMethod, queryParams, collectionQueryParams, postBody, headerParams, authNames, _callback);
    }

    private void addQueryParam(List<Pair> queryParams, String paramName, Object paramValue) {
        if (paramValue != null) {
            LOGGER.trace("Adding query parameter of {} with value of {}", (Object)paramName, paramValue);
            queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        }
    }
}

