/*
 * Consumer Data Standards
 * Sample client library to Demonstrate the Consumer Data Right APIs
 *
 * NOTE: This class is auto generated by the codegen artefact
 * https://github.com/ConsumerDataStandardsAustralia/java-artefacts/codegen
 */
package au.org.consumerdatastandards.client.model;

import java.util.Objects;

public class LinksPaginated {

  private String first;

  private String last;

  private String next;

  private String prev;

  private String self;

  /**
   * URI to the first page of this set. Mandatory if this response is not the first page
   * @return first
   */
  public String getFirst() {
    return first;
  }

  public void setFirst(String first) {
    this.first = first;
  }

  /**
   * URI to the last page of this set. Mandatory if this response is not the last page
   * @return last
   */
  public String getLast() {
    return last;
  }

  public void setLast(String last) {
    this.last = last;
  }

  /**
   * URI to the next page of this set. Mandatory if this response is not the last page
   * @return next
   */
  public String getNext() {
    return next;
  }

  public void setNext(String next) {
    this.next = next;
  }

  /**
   * URI to the previous page of this set. Mandatory if this response is not the first page
   * @return prev
   */
  public String getPrev() {
    return prev;
  }

  public void setPrev(String prev) {
    this.prev = prev;
  }

  /**
   * Fully qualified link to this API call
   * @return self
   */
  public String getSelf() {
    return self;
  }

  public void setSelf(String self) {
    this.self = self;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LinksPaginated linksPaginated = (LinksPaginated) o;
    return Objects.equals(this.first, linksPaginated.first) &&
        Objects.equals(this.last, linksPaginated.last) &&
        Objects.equals(this.next, linksPaginated.next) &&
        Objects.equals(this.prev, linksPaginated.prev) &&
        Objects.equals(this.self, linksPaginated.self);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        first,
        last,
        next,
        prev,
        self);
  }

  @Override
  public String toString() {
    return "class LinksPaginated {\n" +
        "    first: " + toIndentedString(first) + "\n" +
        "    last: " + toIndentedString(last) + "\n" +
        "    next: " + toIndentedString(next) + "\n" +
        "    prev: " + toIndentedString(prev) + "\n" +
        "    self: " + toIndentedString(self) + "\n" +
        "}";
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
