/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli.support;

import au.org.consumerdatastandards.client.ApiClient;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import ch.qos.logback.classic.Logger;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.CreationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiUtil {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(ApiUtil.class);
    private static final List<String> VALID_PROXY_TYPES = Arrays.asList("HTTP:", "HTTPS:", "SOCKS:");

    public static ApiClient createApiClient(ApiClientOptions clientOptions) throws ApiException {
        String accessToken;
        String serverUrl = clientOptions.getServerUrl();
        if (StringUtils.isBlank((CharSequence)serverUrl)) {
            LOGGER.error("Server Base URL is currently unset, cannot proceed until it is specified using `server` command");
            throw new ApiException("Server URL not set, please use `server` command to set Server URL first");
        }
        if (!ApiUtil.isValidUrl((String)serverUrl)) {
            LOGGER.error("Invalid server url of {} specified, please double check", (Object)serverUrl);
            throw new ApiException("Invalid Server URL, please double check it");
        }
        ApiClient apiClient = new ApiClient();
        OkHttpClient originalHttpClient = apiClient.getHttpClient();
        apiClient.setBasePath(serverUrl);
        LOGGER.info("Server Base URL is set to {}", (Object)serverUrl);
        String userAgent = clientOptions.getUserAgent();
        if (!StringUtils.isBlank((CharSequence)userAgent)) {
            apiClient.setUserAgent(userAgent);
            LOGGER.info("User Agent is set to {}", (Object)userAgent);
        }
        if (StringUtils.isNotBlank((CharSequence)(accessToken = clientOptions.getAccessToken()))) {
            apiClient.addDefaultHeader("Authorization", "Bearer " + accessToken);
            apiClient.addDefaultHeader("x-cds-subject", ApiUtil.getSub((String)accessToken));
        }
        if (clientOptions.isMtlsEnabled()) {
            ApiUtil.validateClientCertSettings((ApiClientOptions)clientOptions);
            String keyFilePath = clientOptions.getKeyFilePath();
            String certFilePath = clientOptions.getCertFilePath();
            try {
                X509Certificate certificate = ApiUtil.loadCertificate((String)certFilePath);
                PublicKey publicKey = certificate.getPublicKey();
                PrivateKey privateKey = ApiUtil.loadPrivateKey((String)keyFilePath);
                KeyPair keyPair = new KeyPair(publicKey, privateKey);
                HeldCertificate heldCertificate = new HeldCertificate(keyPair, certificate);
                OkHttpClient httpClient = ApiUtil.buildHttpClient((OkHttpClient)originalHttpClient, (HeldCertificate)heldCertificate, (X509Certificate[])new X509Certificate[0]);
                apiClient.setHttpClient(httpClient);
            }
            catch (CreationException | IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
                throw new ApiException(e);
            }
            LOGGER.info("Enabled MTLS");
        } else {
            apiClient.setHttpClient(originalHttpClient);
            LOGGER.info("Disabled MTLS");
        }
        String proxy = clientOptions.getProxy();
        if (!StringUtils.isBlank((CharSequence)proxy)) {
            ApiUtil.setProxy((ApiClient)apiClient, (String)proxy);
            LOGGER.info("Proxy is set to {}", (Object)proxy);
        }
        apiClient.setDebugging(clientOptions.isDebugEnabled());
        LOGGER.info("Debugging is set to {}", (Object)apiClient.isDebugging());
        apiClient.setVerifyingSsl(clientOptions.isVerifyingSsl());
        LOGGER.info("Verifying SSL is set to {}", (Object)apiClient.isVerifyingSsl());
        return apiClient;
    }

    private static X509Certificate loadCertificate(String certFilePath) throws CertificateException, FileNotFoundException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(certFilePath));
    }

    private static String getSub(String accessToken) throws ApiException {
        Map map;
        String body = accessToken.split("\\.")[1];
        String json = new String(Base64.decodeBase64((String)body), StandardCharsets.UTF_8);
        ObjectMapper objectMapper = new ObjectMapper();
        1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        try {
            map = (Map)objectMapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new ApiException((Throwable)e);
        }
        return map.get("sub").toString();
    }

    private static PrivateKey loadPrivateKey(String keyFilePath) throws IOException, ApiException, NoSuchAlgorithmException, InvalidKeySpecException {
        FileReader reader = new FileReader(keyFilePath);
        PemReader pemReader = new PemReader((Reader)reader);
        PemObject pemObject = pemReader.readPemObject();
        String type = pemObject.getType();
        String PRIVATE_KEY_TYPE_SUFFIX = "PRIVATE KEY";
        if (!type.endsWith("PRIVATE KEY")) {
            throw new ApiException("Invalid key file content - expecting first line similar to\n-----BEGIN RSA PRIVATE KEY-----");
        }
        String algorithm = type.replace("PRIVATE KEY", "").trim();
        if (StringUtils.isNotBlank((CharSequence)algorithm) && !"RSA".equals(algorithm)) {
            throw new ApiException("Invalid algorithm for MTLS: " + algorithm);
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
        return ApiUtil.generateRSAPrivateKey((KeySpec)keySpec);
    }

    private static PrivateKey generateRSAPrivateKey(KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }

    private static OkHttpClient buildHttpClient(OkHttpClient httpClient, HeldCertificate heldCertificate, X509Certificate ... intermediates) {
        HandshakeCertificates.Builder builder = new HandshakeCertificates.Builder().addPlatformTrustedCertificates();
        if (heldCertificate != null) {
            builder.heldCertificate(heldCertificate, intermediates);
        }
        HandshakeCertificates handshakeCertificates = builder.build();
        SSLSocketFactory sslSocketFactory = handshakeCertificates.sslSocketFactory();
        X509TrustManager trustManager = handshakeCertificates.trustManager();
        return httpClient.newBuilder().sslSocketFactory(sslSocketFactory, trustManager).build();
    }

    private static void validateClientCertSettings(ApiClientOptions clientOptions) throws ApiException {
        String certFilePath = clientOptions.getCertFilePath();
        String keyFilePath = clientOptions.getKeyFilePath();
        if (StringUtils.isBlank((CharSequence)certFilePath)) {
            throw new ApiException("Client certificate path is not set");
        }
        if (StringUtils.isBlank((CharSequence)keyFilePath)) {
            throw new ApiException("Key file path is not set");
        }
        File certFile = new File(certFilePath);
        File keyFile = new File(keyFilePath);
        if (!certFile.exists()) {
            throw new ApiException("Certificate file " + certFilePath + " cannot be found");
        }
        if (!keyFile.exists()) {
            throw new ApiException("Key file " + keyFilePath + " cannot be found");
        }
    }

    private static void setProxy(ApiClient apiClient, String proxy) throws ApiException {
        OkHttpClient.Builder builder = apiClient.getHttpClient().newBuilder();
        if ("none".equalsIgnoreCase(proxy)) {
            builder.proxy(Proxy.NO_PROXY);
        } else {
            String[] typeAndOther = proxy.split("//");
            if (typeAndOther.length != 2) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            if (!VALID_PROXY_TYPES.contains(typeAndOther[0].toUpperCase())) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            String[] authAndOther = typeAndOther[1].split("@");
            if (authAndOther.length > 2) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            String[] hostAndPort = authAndOther[authAndOther.length - 1].split(":");
            if (hostAndPort.length != 2) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            String host = hostAndPort[0];
            String port = hostAndPort[1];
            if (!port.matches("[1-9]\\d*")) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            int portNumber = Integer.parseInt(port);
            builder.proxy(new Proxy(ApiUtil.getProxyType((String)typeAndOther[0]), new InetSocketAddress(host, portNumber)));
            if (authAndOther.length > 1) {
                String[] userAndPass = authAndOther[0].split(":", 2);
                if (userAndPass.length != 2) {
                    ApiUtil.printProxyExamples();
                    throw new ApiException("Invalid proxy, please double check it.");
                }
                Authenticator proxyAuthenticator = (route, response) -> {
                    String credential = Credentials.basic((String)userAndPass[0], (String)userAndPass[1]);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                };
                builder.proxyAuthenticator(proxyAuthenticator);
            }
        }
        apiClient.setHttpClient(builder.build());
    }

    private static Proxy.Type getProxyType(String type) {
        if (type.equalsIgnoreCase("socks:")) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.HTTP;
    }

    private static void printProxyExamples() {
        LOGGER.info("Valid proxy examples:");
        LOGGER.info("http://http.proxy:8080");
        LOGGER.info("https://https.proxy:8443");
        LOGGER.info("socks://socks.proxy:5500");
        LOGGER.info("http://user:pass@http.proxy:8080");
        LOGGER.info("https://user:pass@https.proxy:8443");
        LOGGER.info("socks://user:pass@socks.proxy:5500");
    }

    private static boolean isValidUrl(String url) {
        String lowerCaseUrl = url.toLowerCase();
        if (!lowerCaseUrl.startsWith("https://") && !lowerCaseUrl.startsWith("http://")) {
            LOGGER.error("Invalid scheme specified for server url, only https:// and http:// are supported");
            return false;
        }
        try {
            new URL(url);
            LOGGER.trace("Server URL of {} passes validation", (Object)url);
            return true;
        }
        catch (MalformedURLException e) {
            LOGGER.error("Specified URL of {} is malformed and exception caught: {}", (Object)url, (Object)e.getMessage());
            return false;
        }
    }
}

