/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.conformance.ConformanceError;
import au.org.consumerdatastandards.conformance.ConformanceModel;
import au.org.consumerdatastandards.conformance.Payload;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="Reference Testing")
public class ReferenceTest {
    private PayloadValidator payloadValidator = new PayloadValidator();
    @Autowired
    ApiClientOptions apiClientOptions;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceTest.class);

    @ShellMethod(value="Retrieve current conformance check status")
    public void payloadValidationStatus() {
        LOGGER.info("Automatic payload validation setting: {}", (Object)this.apiClientOptions.isValidationEnabled());
    }

    @ShellMethod(value="Validate all Payloads Automatically")
    public void autoValidate(@ShellOption(help="enable or disable") String enableValidation) throws IOException {
        Boolean validateEnable = Boolean.parseBoolean(enableValidation);
        this.apiClientOptions.setValidationEnabled(validateEnable.booleanValue());
        this.payloadValidationStatus();
    }

    @ShellMethod(value="Validate json payload(s) against CDS")
    public void validatePath(@ShellOption(value={"-f"}, help="payload file or folder") String fileOrFolder, @ShellOption(value={"-m"}, help="model", defaultValue="") String model) throws IOException {
        File file = new File(fileOrFolder);
        if (!file.exists()) {
            LOGGER.error("Unable to find the specified file for validation: {}", (Object)fileOrFolder);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                LOGGER.error("No files found in directory: {}", (Object)file.getAbsolutePath());
            } else {
                for (File oneFile : files) {
                    this.validatePath(oneFile.getAbsolutePath(), model);
                }
            }
        } else {
            List payloadErrors;
            List list = payloadErrors = StringUtils.isBlank((CharSequence)model) ? this.payloadValidator.validateFile(file) : this.payloadValidator.validateFile(file, model);
            if (!payloadErrors.isEmpty()) {
                LOGGER.error("Encountered errors while validating: {}", (Object)file.getAbsolutePath());
                for (int i = 0; i < payloadErrors.size(); ++i) {
                    LOGGER.error("\n{}. {}", (Object)(i + 1), (Object)((ConformanceError)payloadErrors.get(i)).getDescription());
                }
            } else {
                LOGGER.info("Validation of {} successful", (Object)file.getAbsolutePath());
            }
        }
    }

    @ShellMethod(value="List top-level payload models")
    public String listPayloadModels() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TreeSet<String> topLevelModels = new TreeSet<String>();
        ConformanceModel conformanceModel = this.payloadValidator.getConformanceModel();
        for (Class payloadModel : conformanceModel.getPayloadModels()) {
            Payload.Type payloadType = conformanceModel.getPayload(payloadModel).getPayloadType();
            if (!Payload.Type.RESPONSE_BODY.equals((Object)payloadType)) continue;
            topLevelModels.add(payloadModel.getSimpleName());
        }
        for (String topLevelModel : topLevelModels) {
            pw.println(topLevelModel);
        }
        return sw.toString();
    }
}

