/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.api.CommonDiscoveryAPI;
import au.org.consumerdatastandards.client.cli.ApiCliBase;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import au.org.consumerdatastandards.client.cli.support.JsonPrinter;
import au.org.consumerdatastandards.client.model.CommonDiscoveryStatus;
import au.org.consumerdatastandards.client.model.ResponseDiscoveryOutagesList;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import au.org.consumerdatastandards.support.ResponseCode;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="CommonDiscovery")
public class CommonDiscovery
extends ApiCliBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDiscovery.class);
    @Autowired
    ApiClientOptions apiClientOptions;
    private PayloadValidator payloadValidator = new PayloadValidator();
    private final CommonDiscoveryAPI api = new CommonDiscoveryAPI();

    @ShellMethod(value="Get outages")
    public String getOutages(@ShellOption(defaultValue="__NULL__") Boolean check) throws Exception {
        LOGGER.info("Get outages CLI initiated");
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseDiscoveryOutagesList response = this.api.getOutages();
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getOutagesCall(null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getOutages", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="Get status")
    public String getStatus(@ShellOption(defaultValue="__NULL__") Boolean check) throws Exception {
        LOGGER.info("Get status CLI initiated");
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        CommonDiscoveryStatus response = this.api.getStatus();
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getStatusCall(null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getStatus", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }
}

