/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.api.CommonCustomerAPI;
import au.org.consumerdatastandards.client.cli.ApiCliBase;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import au.org.consumerdatastandards.client.cli.support.JsonPrinter;
import au.org.consumerdatastandards.client.model.ResponseCommonCustomer;
import au.org.consumerdatastandards.client.model.ResponseCommonCustomerDetail;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import au.org.consumerdatastandards.support.ResponseCode;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="CommonCustomer")
public class CommonCustomer
extends ApiCliBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonCustomer.class);
    @Autowired
    ApiClientOptions apiClientOptions;
    private PayloadValidator payloadValidator = new PayloadValidator();
    private final CommonCustomerAPI api = new CommonCustomerAPI();

    @ShellMethod(value="Get customer")
    public String getCustomer(@ShellOption(defaultValue="__NULL__") Boolean check) throws Exception {
        LOGGER.info("Get customer CLI initiated");
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseCommonCustomer response = this.api.getCustomer();
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getCustomerCall(null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getCustomer", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="Get customer detail")
    public String getCustomerDetail(@ShellOption(defaultValue="__NULL__") Boolean check) throws Exception {
        LOGGER.info("Get customer detail CLI initiated");
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseCommonCustomerDetail response = this.api.getCustomerDetail();
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getCustomerDetailCall(null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getCustomerDetail", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }
}

