/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="Common Functions")
public class Common {
    @Autowired
    ApiClientOptions apiClientOptions;
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(Common.class);

    @ShellMethod(value="Set CDS server URL, e.g. http://data.holder/cds-au/v1")
    public void server(@ShellOption String url) {
        this.apiClientOptions.setServerUrl(url);
        LOGGER.info("Server URL is set to {}", (Object)this.apiClientOptions.getServerUrl());
    }

    @ShellMethod(value="Set proxy, e.g. http://http-proxy:8080, https://https-proxy:8443, socks://socks-proxy:5050, none")
    public void proxy(@ShellOption String proxy) {
        this.apiClientOptions.setProxy(proxy);
        LOGGER.info("Proxy is set to {}", (Object)this.apiClientOptions.getProxy());
    }

    @ShellMethod(value="Set verifyingSsl, e.g. true, false")
    public void verifyingSsl(@ShellOption String verifyingSsl) {
        this.apiClientOptions.setVerifyingSsl(Boolean.getBoolean(verifyingSsl));
        LOGGER.info("VerifyingSsl is set to {}", (Object)verifyingSsl);
    }

    @ShellMethod(value="Setup minimum log level, default is INFO")
    public void setLogLevel(@ShellOption Level targetLevel) {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(targetLevel);
    }

    @ShellMethod(value="Setup client certificate to enable MTLS connection to the server")
    public void setClientCert(@ShellOption(value={"cert file path"}) String certFilePath, @ShellOption(value={"key file path"}) String keyFilePath, @ShellOption(value={"enable MTLS or not"}, defaultValue="true") boolean mtlsEnabled) {
        this.apiClientOptions.setCertFilePath(certFilePath);
        LOGGER.info("Client certificate file path is set to {}", (Object)certFilePath);
        this.apiClientOptions.setKeyFilePath(keyFilePath);
        LOGGER.info("Client key file path is set to {}", (Object)keyFilePath);
        if (mtlsEnabled) {
            this.enableMTLS();
        } else {
            this.disableMTLS();
        }
    }

    @ShellMethod(value="Enable MTLS")
    public void enableMTLS() {
        this.apiClientOptions.setMtlsEnabled(true);
        LOGGER.info("MTLS enabled");
    }

    @ShellMethod(value="Disable MTLS")
    public void disableMTLS() {
        this.apiClientOptions.setMtlsEnabled(false);
        LOGGER.info("MTLS disabled");
    }

    @ShellMethod(value="Retrieve current minimum log level")
    public void getLogLevel() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Level currentLevel = root.getLevel();
        root.setLevel(Level.INFO);
        LOGGER.info("Log level currently set to: {}", (Object)currentLevel);
        root.setLevel(currentLevel);
    }

    @ShellMethod(value="Set browser user-agent")
    public void setUserAgent(@ShellOption String userAgent) {
        this.apiClientOptions.setUserAgent(userAgent);
    }

    @ShellMethod(value="Get browser user-agent")
    public void getUserAgent() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.INFO);
        LOGGER.info("User Agent currently set to: {}", (Object)this.apiClientOptions.getUserAgent());
    }

    @ShellMethod(value="Enable client debug")
    public void enableClientDebug(@ShellOption(help="true / false") String debugEnabled) {
        this.apiClientOptions.setDebugEnabled(Boolean.parseBoolean(debugEnabled));
    }

    @ShellMethod(value="Client debug enabled")
    public void getClientDebug() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.INFO);
        LOGGER.info("Client debug is currently set to: {}", (Object)this.apiClientOptions.isDebugEnabled());
    }

    @ShellMethod(value="Set access token to send as the Authorization: Bearer header")
    public void accessToken(@ShellOption String jwt) {
        this.apiClientOptions.setAccessToken(jwt);
    }
}

