/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.api.BankingScheduledPaymentsAPI;
import au.org.consumerdatastandards.client.cli.ApiCliBase;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import au.org.consumerdatastandards.client.cli.support.JsonPrinter;
import au.org.consumerdatastandards.client.model.RequestAccountIds;
import au.org.consumerdatastandards.client.model.ResponseBankingScheduledPaymentsList;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import au.org.consumerdatastandards.support.ResponseCode;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="BankingScheduledPayments")
public class BankingScheduledPayments
extends ApiCliBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingScheduledPayments.class);
    @Autowired
    ApiClientOptions apiClientOptions;
    private PayloadValidator payloadValidator = new PayloadValidator();
    private final BankingScheduledPaymentsAPI api = new BankingScheduledPaymentsAPI();

    @ShellMethod(value="List scheduled payments")
    public String listScheduledPayments(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") String accountId, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize) throws Exception {
        LOGGER.info("List scheduled payments CLI initiated with accountId: {}, page: {}, page-size: {}", new Object[]{accountId, page, pageSize});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingScheduledPaymentsList response = this.api.listScheduledPayments(accountId, page, pageSize);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listScheduledPaymentsCall(accountId, page, pageSize, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listScheduledPayments", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="List scheduled payments specific accounts")
    public String listScheduledPaymentsSpecificAccounts(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") RequestAccountIds accountIds, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize) throws Exception {
        LOGGER.info("List scheduled payments specific accounts CLI initiated with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingScheduledPaymentsList response = this.api.listScheduledPaymentsSpecificAccounts(accountIds, page, pageSize);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listScheduledPaymentsSpecificAccountsCall(accountIds, page, pageSize, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listScheduledPaymentsSpecificAccounts", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }
}

