/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.api.BankingPayeesAPI;
import au.org.consumerdatastandards.client.cli.ApiCliBase;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import au.org.consumerdatastandards.client.cli.support.JsonPrinter;
import au.org.consumerdatastandards.client.model.ResponseBankingPayeeById;
import au.org.consumerdatastandards.client.model.ResponseBankingPayeeList;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import au.org.consumerdatastandards.support.ResponseCode;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="BankingPayees")
public class BankingPayees
extends ApiCliBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingPayees.class);
    @Autowired
    ApiClientOptions apiClientOptions;
    private PayloadValidator payloadValidator = new PayloadValidator();
    private final BankingPayeesAPI api = new BankingPayeesAPI();

    @ShellMethod(value="Get payee detail")
    public String getPayeeDetail(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") String payeeId) throws Exception {
        LOGGER.info("Get payee detail CLI initiated with payeeId: {}", (Object)payeeId);
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingPayeeById response = this.api.getPayeeDetail(payeeId);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getPayeeDetailCall(payeeId, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getPayeeDetail", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="List payees")
    public String listPayees(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize, @ShellOption(defaultValue="__NULL__") BankingPayeesAPI.ParamType type) throws Exception {
        LOGGER.info("List payees CLI initiated with page: {}, page-size: {}, type: {}", new Object[]{page, pageSize, type});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingPayeeList response = this.api.listPayees(page, pageSize, type);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listPayeesCall(page, pageSize, type, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listPayees", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }
}

