/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.api.BankingDirectDebitsAPI;
import au.org.consumerdatastandards.client.cli.ApiCliBase;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import au.org.consumerdatastandards.client.cli.support.JsonPrinter;
import au.org.consumerdatastandards.client.model.RequestAccountIds;
import au.org.consumerdatastandards.client.model.ResponseBankingDirectDebitAuthorisationList;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import au.org.consumerdatastandards.support.ResponseCode;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="BankingDirectDebits")
public class BankingDirectDebits
extends ApiCliBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingDirectDebits.class);
    @Autowired
    ApiClientOptions apiClientOptions;
    private PayloadValidator payloadValidator = new PayloadValidator();
    private final BankingDirectDebitsAPI api = new BankingDirectDebitsAPI();

    @ShellMethod(value="List direct debits")
    public String listDirectDebits(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") String accountId, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize) throws Exception {
        LOGGER.info("List direct debits CLI initiated with accountId: {}, page: {}, page-size: {}", new Object[]{accountId, page, pageSize});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingDirectDebitAuthorisationList response = this.api.listDirectDebits(accountId, page, pageSize);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listDirectDebitsCall(accountId, page, pageSize, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listDirectDebits", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="List direct debits specific accounts")
    public String listDirectDebitsSpecificAccounts(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") RequestAccountIds accountIds, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize) throws Exception {
        LOGGER.info("List direct debits specific accounts CLI initiated with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingDirectDebitAuthorisationList response = this.api.listDirectDebitsSpecificAccounts(accountIds, page, pageSize);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listDirectDebitsSpecificAccountsCall(accountIds, page, pageSize, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listDirectDebitsSpecificAccounts", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }
}

