/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.api.BankingAccountsAPI;
import au.org.consumerdatastandards.client.cli.ApiCliBase;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import au.org.consumerdatastandards.client.cli.support.JsonPrinter;
import au.org.consumerdatastandards.client.model.ParamAccountOpenStatus;
import au.org.consumerdatastandards.client.model.ParamProductCategory;
import au.org.consumerdatastandards.client.model.RequestAccountIds;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountById;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountList;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountsBalanceById;
import au.org.consumerdatastandards.client.model.ResponseBankingAccountsBalanceList;
import au.org.consumerdatastandards.client.model.ResponseBankingTransactionById;
import au.org.consumerdatastandards.client.model.ResponseBankingTransactionList;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import au.org.consumerdatastandards.support.ResponseCode;
import java.time.OffsetDateTime;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="BankingAccounts")
public class BankingAccounts
extends ApiCliBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingAccounts.class);
    @Autowired
    ApiClientOptions apiClientOptions;
    private PayloadValidator payloadValidator = new PayloadValidator();
    private final BankingAccountsAPI api = new BankingAccountsAPI();

    @ShellMethod(value="Get account detail")
    public String getAccountDetail(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") String accountId) throws Exception {
        LOGGER.info("Get account detail CLI initiated with accountId: {}", (Object)accountId);
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingAccountById response = this.api.getAccountDetail(accountId);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getAccountDetailCall(accountId, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getAccountDetail", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="Get transaction detail")
    public String getTransactionDetail(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") String accountId, @ShellOption(defaultValue="__NULL__") String transactionId) throws Exception {
        LOGGER.info("Get transaction detail CLI initiated with accountId: {}, transactionId: {}", (Object)accountId, (Object)transactionId);
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingTransactionById response = this.api.getTransactionDetail(accountId, transactionId);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getTransactionDetailCall(accountId, transactionId, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getTransactionDetail", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="Get transactions")
    public String getTransactions(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") String accountId, @ShellOption(defaultValue="__NULL__") String maxAmount, @ShellOption(defaultValue="__NULL__") String minAmount, @ShellOption(defaultValue="__NULL__") OffsetDateTime newestTime, @ShellOption(defaultValue="__NULL__") OffsetDateTime oldestTime, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize, @ShellOption(defaultValue="__NULL__") String text) throws Exception {
        LOGGER.info("Get transactions CLI initiated with accountId: {}, max-amount: {}, min-amount: {}, newest-time: {}, oldest-time: {}, page: {}, page-size: {}, text: {}", new Object[]{accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingTransactionList response = this.api.getTransactions(accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.getTransactionsCall(accountId, maxAmount, minAmount, newestTime, oldestTime, page, pageSize, text, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getTransactions", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="List accounts")
    public String listAccounts(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") Boolean isOwned, @ShellOption(defaultValue="__NULL__") ParamAccountOpenStatus openStatus, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize, @ShellOption(defaultValue="__NULL__") ParamProductCategory productCategory) throws Exception {
        LOGGER.info("List accounts CLI initiated with is-owned: {}, open-status: {}, page: {}, page-size: {}, product-category: {}", new Object[]{isOwned, openStatus, page, pageSize, productCategory});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingAccountList response = this.api.listAccounts(isOwned, openStatus, page, pageSize, productCategory);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listAccountsCall(isOwned, openStatus, page, pageSize, productCategory, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listAccounts", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="List balance")
    public String listBalance(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") String accountId) throws Exception {
        LOGGER.info("List balance CLI initiated with accountId: {}", (Object)accountId);
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingAccountsBalanceById response = this.api.listBalance(accountId);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listBalanceCall(accountId, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listBalance", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }

    @ShellMethod(value="List balances specific accounts")
    public String listBalancesSpecificAccounts(@ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") RequestAccountIds accountIds, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize) throws Exception {
        LOGGER.info("List balances specific accounts CLI initiated with accountIds: {}, page: {}, page-size: {}", new Object[]{accountIds, page, pageSize});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        ResponseBankingAccountsBalanceList response = this.api.listBalancesSpecificAccounts(accountIds, page, pageSize);
        if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
            LOGGER.info("Payload validation is enabled");
            Call call = this.api.listBalancesSpecificAccountsCall(accountIds, page, pageSize, null);
            List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listBalancesSpecificAccounts", ResponseCode.OK);
            if (!conformanceErrors.isEmpty()) {
                this.throwConformanceErrors(conformanceErrors);
            }
        }
        return JsonPrinter.toJson((Object)response);
    }
}

