/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli.support;

import au.org.consumerdatastandards.client.ApiClient;
import au.org.consumerdatastandards.client.ApiException;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import ch.qos.logback.classic.Logger;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiUtil {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(ApiUtil.class);
    private static final List<String> VALID_PROXY_TYPES = Arrays.asList("HTTP:", "HTTPS:", "SOCKS:");

    public static ApiClient createApiClient(ApiClientOptions clientOptions) throws ApiException {
        String proxy;
        String accessToken;
        String serverUrl = clientOptions.getServerUrl();
        if (StringUtils.isBlank((CharSequence)serverUrl)) {
            LOGGER.error("Server Base URL is currently unset, cannot proceed until it is specified using `server` command");
            throw new ApiException("Server URL not set, please use `server` command to set Server URL first");
        }
        if (!ApiUtil.isValidUrl((String)serverUrl)) {
            LOGGER.error("Invalid server url of {} specified, please double check", (Object)serverUrl);
            throw new ApiException("Invalid Server URL, please double check it");
        }
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(serverUrl);
        LOGGER.info("Server Base URL is set to {}", (Object)serverUrl);
        String userAgent = clientOptions.getUserAgent();
        if (!StringUtils.isBlank((CharSequence)userAgent)) {
            apiClient.setUserAgent(userAgent);
            LOGGER.info("User Agent is set to {}", (Object)userAgent);
        }
        if (StringUtils.isNotBlank((CharSequence)(accessToken = clientOptions.getAccessToken()))) {
            apiClient.addDefaultHeader("Authorization", "Bearer " + accessToken);
        }
        if (!StringUtils.isBlank((CharSequence)(proxy = clientOptions.getProxy()))) {
            ApiUtil.setProxy((ApiClient)apiClient, (String)proxy);
            LOGGER.info("Proxy is set to {}", (Object)proxy);
        }
        apiClient.setDebugging(clientOptions.isDebugEnabled());
        LOGGER.info("Debugging is set to {}", (Object)apiClient.isDebugging());
        apiClient.setVerifyingSsl(clientOptions.isVerifyingSsl());
        LOGGER.info("Verifying SSL is set to {}", (Object)apiClient.isVerifyingSsl());
        return apiClient;
    }

    private static void setProxy(ApiClient apiClient, String proxy) throws ApiException {
        OkHttpClient.Builder builder = apiClient.getHttpClient().newBuilder();
        if ("none".equalsIgnoreCase(proxy)) {
            builder.proxy(Proxy.NO_PROXY);
        } else {
            String[] typeAndOther = proxy.split("//");
            if (typeAndOther.length != 2) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            if (!VALID_PROXY_TYPES.contains(typeAndOther[0].toUpperCase())) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            String[] authAndOther = typeAndOther[1].split("@");
            if (authAndOther.length > 2) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            String[] hostAndPort = authAndOther[authAndOther.length - 1].split(":");
            if (hostAndPort.length != 2) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            String host = hostAndPort[0];
            String port = hostAndPort[1];
            if (!port.matches("[1-9]\\d*")) {
                ApiUtil.printProxyExamples();
                throw new ApiException("Invalid proxy, please double check it.");
            }
            int portNumber = Integer.parseInt(port);
            builder.proxy(new Proxy(ApiUtil.getProxyType((String)typeAndOther[0]), new InetSocketAddress(host, portNumber)));
            if (authAndOther.length > 1) {
                String[] userAndPass = authAndOther[0].split(":", 2);
                if (userAndPass.length != 2) {
                    ApiUtil.printProxyExamples();
                    throw new ApiException("Invalid proxy, please double check it.");
                }
                Authenticator proxyAuthenticator = (route, response) -> {
                    String credential = Credentials.basic((String)userAndPass[0], (String)userAndPass[1]);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                };
                builder.proxyAuthenticator(proxyAuthenticator);
            }
        }
        apiClient.setHttpClient(builder.build());
    }

    private static Proxy.Type getProxyType(String type) {
        if (type.equalsIgnoreCase("socks:")) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.HTTP;
    }

    private static void printProxyExamples() {
        LOGGER.info("Valid proxy examples:");
        LOGGER.info("http://http.proxy:8080");
        LOGGER.info("https://https.proxy:8443");
        LOGGER.info("socks://socks.proxy:5500");
        LOGGER.info("http://user:pass@http.proxy:8080");
        LOGGER.info("https://user:pass@https.proxy:8443");
        LOGGER.info("socks://user:pass@socks.proxy:5500");
    }

    private static boolean isValidUrl(String url) {
        String lowerCaseUrl = url.toLowerCase();
        if (!lowerCaseUrl.startsWith("https://") && !lowerCaseUrl.startsWith("http://")) {
            LOGGER.error("Invalid scheme specified for server url, only https:// and http:// are supported");
            return false;
        }
        try {
            new URL(url);
            LOGGER.trace("Server URL of {} passes validation", (Object)url);
            return true;
        }
        catch (MalformedURLException e) {
            LOGGER.error("Specified URL of {} is malformed and exception caught: {}", (Object)url, (Object)e.getMessage());
            return false;
        }
    }
}

