/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="Reference Testing")
public class ReferenceTest {
    private PayloadValidator payloadValidator = new PayloadValidator();
    @Autowired
    ApiClientOptions apiClientOptions;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceTest.class);

    @ShellMethod(value="Retrieve current conformance check status")
    public void payloadValidationStatus() {
        LOGGER.info("Automatic payload validation setting: {}", (Object)this.apiClientOptions.isValidationEnabled());
    }

    @ShellMethod(value="Validate all Payloads Automatically")
    public void autoValidate(@ShellOption(help="enable or disable") String enableValidation) throws IOException {
        Boolean validateEnable = Boolean.parseBoolean(enableValidation);
        this.apiClientOptions.setValidationEnabled(validateEnable.booleanValue());
        this.payloadValidationStatus();
    }

    @ShellMethod(value="Validate json payload(s) against CDS")
    public void validatePath(@ShellOption(value={"-f"}, help="payload file or folder") String fileOrFolder) throws IOException {
        File file = new File(fileOrFolder);
        if (!file.exists()) {
            LOGGER.error("Unable to find the specified file for validation: {}", (Object)fileOrFolder);
        } else if (file.isDirectory()) {
            File[] files;
            for (File oneFile : files = file.listFiles()) {
                this.payloadValidator.validateFile(new File(oneFile.getAbsolutePath()));
            }
        } else {
            List payloadErrors = this.payloadValidator.validateFile(file);
            if (!payloadErrors.isEmpty()) {
                LOGGER.error("Encountered errors while validating: {}", (Object)file.getAbsolutePath());
                payloadErrors.forEach(e -> LOGGER.error("\n" + e.getDescription()));
            } else {
                LOGGER.info("Validation of {} successful", (Object)file.getAbsolutePath());
            }
        }
    }
}

