/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.client.cli;

import au.org.consumerdatastandards.client.api.BankingProductsAPI;
import au.org.consumerdatastandards.client.cli.support.ApiClientOptions;
import au.org.consumerdatastandards.client.cli.support.ApiUtil;
import au.org.consumerdatastandards.client.cli.support.JsonPrinter;
import au.org.consumerdatastandards.client.model.ParamEffective;
import au.org.consumerdatastandards.client.model.ParamProductCategory;
import au.org.consumerdatastandards.client.model.ResponseBankingProductById;
import au.org.consumerdatastandards.client.model.ResponseBankingProductList;
import au.org.consumerdatastandards.conformance.ConformanceError;
import au.org.consumerdatastandards.conformance.PayloadValidator;
import au.org.consumerdatastandards.support.ResponseCode;
import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@ShellCommandGroup(value="Products API")
public class BankingProducts {
    @Autowired
    ApiClientOptions apiClientOptions;
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingProducts.class);
    private PayloadValidator payloadValidator = new PayloadValidator();
    private final BankingProductsAPI api = new BankingProductsAPI();

    @ShellMethod(value="List Products")
    public void listProducts(@ShellOption(defaultValue="__NULL__") Boolean summary, @ShellOption(defaultValue="__NULL__") Boolean check, @ShellOption(defaultValue="__NULL__") ParamEffective effective, @ShellOption(defaultValue="__NULL__") String updatedSince, @ShellOption(defaultValue="__NULL__") String brand, @ShellOption(defaultValue="__NULL__") ParamProductCategory productCategory, @ShellOption(defaultValue="__NULL__") Integer page, @ShellOption(defaultValue="__NULL__") Integer pageSize) throws Exception {
        LOGGER.info("List Products CLI initiated with effective: {}, updated-since: {}, brand: {}, product-category: {}, page: {}, page-size: {}", new Object[]{effective, updatedSince, brand, productCategory, page, pageSize});
        if (this.apiClientOptions.getUserAgent() != null) {
            LOGGER.info("User agent specified as {}", (Object)this.apiClientOptions.getUserAgent());
        }
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        try {
            ResponseBankingProductList response = this.api.listProducts(effective, updatedSince, brand, productCategory, page, pageSize);
            if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
                LOGGER.info("Conformance verification is enabled, initiating conformance check on payload");
                Call call = this.api.listProductsCall(effective, updatedSince, brand, productCategory, page, pageSize, null);
                List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "listProducts", ResponseCode.OK);
                if (conformanceErrors.isEmpty()) {
                    LOGGER.info(JsonPrinter.toJson((Object)response));
                } else {
                    this.logConformanceErrors(conformanceErrors);
                }
            } else if (summary != null && summary.booleanValue() && response.getData() != null && response.getData().getProducts() != null) {
                List bankingProducts = response.getData().getProducts();
                for (String logLine : AsciiTable.getTable((Collection)bankingProducts, Arrays.asList(new Column().header("ID").with(bankingProduct -> bankingProduct.getProductId()), new Column().header("Name").with(bankingProduct -> bankingProduct.getName()), new Column().header("Product Category").with(bankingProduct -> bankingProduct.getProductCategory().toString()))).split("\\r?\\n")) {
                    LOGGER.info(logLine);
                }
            } else {
                LOGGER.info(JsonPrinter.toJson((Object)response));
            }
        }
        catch (Exception e) {
            LOGGER.error("Encountered error while performing listProducts: {}", (Object)e.getMessage());
            throw e;
        }
    }

    @ShellMethod(value="Get Product Detail")
    public void getProductDetail(@ShellOption(defaultValue="__NULL__") String productId, @ShellOption(defaultValue="__NULL__") Boolean check) throws Exception {
        LOGGER.info("Get Product Detail CLI initiated with product id {}", (Object)productId);
        this.api.setApiClient(ApiUtil.createApiClient((ApiClientOptions)this.apiClientOptions));
        try {
            ResponseBankingProductById response = this.api.getProductDetail(productId);
            if (this.apiClientOptions.isValidationEnabled() || check != null && check.booleanValue()) {
                LOGGER.debug("Conformance verification is enabled, initiating conformance check on payload");
                Call call = this.api.getProductDetailCall(productId, null);
                List conformanceErrors = this.payloadValidator.validateResponse(call.request().url().toString(), (Object)response, "getProductDetail", ResponseCode.OK);
                if (conformanceErrors.isEmpty()) {
                    LOGGER.info(JsonPrinter.toJson((Object)response));
                } else {
                    this.logConformanceErrors(conformanceErrors);
                }
            } else {
                LOGGER.info(JsonPrinter.toJson((Object)response));
            }
        }
        catch (Exception e) {
            LOGGER.error("Encountered error while performing getProductDetail: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void logConformanceErrors(List<ConformanceError> conformanceErrors) {
        if (conformanceErrors != null) {
            if (conformanceErrors.isEmpty()) {
                LOGGER.info("Received zero conformance errors for listProductsCall");
            } else {
                LOGGER.warn("Received {} conformance errors for listProductsCall", (Object)conformanceErrors.size());
                for (ConformanceError conformanceError : conformanceErrors) {
                    LOGGER.warn("Conformance Error: {}", (Object)conformanceError.getDescription());
                }
                LOGGER.info("Found a total of {} conformance errors", (Object)conformanceErrors.size());
            }
        }
    }
}

