/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.api.banking.models;

import au.org.consumerdatastandards.api.banking.models.BankingScheduledPaymentInterval;
import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.CustomDataType;
import au.org.consumerdatastandards.support.data.DataDefinition;
import au.org.consumerdatastandards.support.data.Property;
import java.util.List;

@DataDefinition(description="Indicates that the schedule of payments is defined by a series of intervals. Mandatory if recurrenceUType is set to intervalSchedule")
public class BankingScheduledPaymentRecurrenceIntervalSchedule {
    @Property(description="The limit date after which no more payments should be made using this schedule. If both finalPaymentDate and paymentsRemaining are present then payments will stop according to the most constraining value. If neither field is present the payments will continue indefinitely")
    @CDSDataType(value=CustomDataType.Date)
    String finalPaymentDate;
    @Property(description="Indicates the number of payments remaining in the schedule. If both finalPaymentDate and paymentsRemaining are present then payments will stop according to the most constraining value, If neither field is present the payments will continue indefinitely")
    @CDSDataType(value=CustomDataType.PositiveInteger)
    Integer paymentsRemaining;
    @Property(description="Enumerated field giving the treatment where a scheduled payment date is not a business day.  If absent assumed to be ON")
    NonBusinessDayTreatment nonBusinessDayTreatment = NonBusinessDayTreatment.ON;
    @Property(description="An array of interval objects defining the payment schedule.  Each entry in the array is additive, in that it adds payments to the overall payment schedule.  If multiple intervals result in a payment on the same day then only one payment will be made. Must have at least one entry", required=true)
    List<BankingScheduledPaymentInterval> intervals;

    public static enum NonBusinessDayTreatment {
        AFTER,
        BEFORE,
        ON,
        ONLY;

    }
}

