/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.api.banking;

import au.org.consumerdatastandards.api.banking.models.ParamProductCategory;
import au.org.consumerdatastandards.api.banking.models.ResponseBankingProductById;
import au.org.consumerdatastandards.api.banking.models.ResponseBankingProductList;
import au.org.consumerdatastandards.support.Endpoint;
import au.org.consumerdatastandards.support.EndpointResponse;
import au.org.consumerdatastandards.support.Param;
import au.org.consumerdatastandards.support.ParamLocation;
import au.org.consumerdatastandards.support.RequestMethod;
import au.org.consumerdatastandards.support.ResponseCode;
import au.org.consumerdatastandards.support.ResponseHeader;
import au.org.consumerdatastandards.support.Section;
import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.CustomAttribute;
import au.org.consumerdatastandards.support.data.CustomAttributes;
import au.org.consumerdatastandards.support.data.CustomDataType;

@Section(name="BankingProducts", tags={"Banking", "Products"})
public interface BankingProductsAPI {
    @Endpoint(path="/banking/products/{productId}", summary="Get Product Detail", description="Obtain detailed information on a single product offered openly to the market", requestMethod=RequestMethod.GET, operationId="getProductDetail", responses={@EndpointResponse(responseCode=ResponseCode.OK, description="Success", headers={@ResponseHeader(name="x-v", type="string", description="The [version](#response-headers) of the API end point that the data holder has responded with.")}, content=ResponseBankingProductById.class)})
    @CustomAttributes(value={@CustomAttribute(name="x-version", value="1")})
    public ResponseBankingProductById getProductDetail(@Param(name="productId", description="ID of the specific product requested", in=ParamLocation.PATH) @CDSDataType(value=CustomDataType.ASCII) String var1, @Param(name="x-v", description="Version of the API end point requested by the client. Must be set to a positive integer. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If the value of [x-min-v](#request-headers) is equal to or higher than the value of [x-v](#request-headers) then the [x-min-v](#request-headers) header should be treated as absent. If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable. See [HTTP Headers](#request-headers)", in=ParamLocation.HEADER, reference="RequestHeader_x-v") String var2, @Param(name="x-min-v", description="Minimum version of the API end point requested by the client. Must be set to a positive integer if provided. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable.", in=ParamLocation.HEADER, reference="RequestHeader_x-min-v") String var3);

    @Endpoint(path="/banking/products", summary="Get Products", description="Obtain a list of products that are currently openly offered to the market  Note that the results returned by this end point are expected to be ordered according to updated-since  ### Conventions In the product reference payloads there are a number of recurring conventions that are explained here, in one place.  #### Arrays Of Features  In the product detail payload there are a number of arrays articulating generic features, constraints, prices, etc. The intent of these arrays is as follows:  - Each element in an array has the same structure so that clients can reliably interpret the payloads - Each element as a type element that is an enumeration of the specific aspect of a product being described, such as types of fees. - Each element has a field name [additionalValue](#productfeaturetypedoc).  This is a generic field with contents that will vary based on the type of object being described. The contents of this field for the ADDITIONAL_CARDS feature is the number of cards allowed while the contents of this field for the MAX_LIMIT constraint would be the maximum credit limit allowed for the product. - An element in these arrays of the same type may appear more than once. For instance, a product may offer two separate loyalty programs that the customer can select from. A fixed term mortgage may have different rates for different term lengths. - An element in these arrays may contain an additionalInfo and additionalInfoUri field. The additionalInfo field is used to provide displayable text clarifying the purpose of the element in some way when the product is presented to a customer. The additionalInfoUri provides a link to externally hosted information specifically relevant to that feature of the product. - Depending on the type of data being represented there may be additional specific fields.  #### URIs To More Information  As the complexities and nuances of a financial product can not easily be fully expressed in a data structure without a high degree of complexity it is necessary to provide additional reference information that a potential customer can access so that they are fully informed of the features and implications of the product. The payloads for product reference therefore contain numerous fields that are provided to allow the product holder to describe the product more fully using a web page hosted on their online channels.  These URIs do not need to all link to different pages. If desired, they can all link to a single hosted page and use difference HTML anchors to focus on a specific topic such as eligibility or fees.  #### Linkage To Accounts From the moment that a customer applies for a product and an account is created the account and the product that spawned it will diverge.  Rates and features of the product may change and a discount may be negotiated for the account.  For this reason, while productCategory is a common field between accounts and products, there is no specific ID that can be used to link an account to a product within the regime.  Similarly, many of the fields and objects in the product payload will appear in the account detail payload but the structures and semantics are not identical as one refers to a product that can potentially be originated and one refers to an account that actual has been instantiated and created along with the associated decisions inherent in that process.  #### Dates It is expected that data consumers needing this data will call relatively frequently to ensure the data they have is representative of the current offering from a bank.  To minimise the volume and frequency of these calls the ability to set a lastUpdated field with the date and time of the last update to this product is included.  A call for a list of products can then be filtered to only return products that have been updated since the last time that data was obtained using the updated-since query parameter.  In addition, the concept of effective date and time has also been included.  This allows for a product to be marked for obsolescence, or introduction, from a certain time without the need for an update to show that a product has been changed.  The inclusion of these dates also removes the need to represent deleted products in the payload.  Products that are no long offered can be marked not effective for a few weeks before they are then removed from the product set as an option entirely.", requestMethod=RequestMethod.GET, operationId="listProducts", responses={@EndpointResponse(responseCode=ResponseCode.OK, description="Success", headers={@ResponseHeader(name="x-v", type="string", description="The [version](#response-headers) of the API end point that the data holder has responded with.")}, content=ResponseBankingProductList.class)})
    @CustomAttributes(value={@CustomAttribute(name="x-version", value="1")})
    public ResponseBankingProductList listProducts(@Param(name="effective", description="Allows for the filtering of products based on whether the current time is within the period of time defined as effective by the effectiveFrom and effectiveTo fields. Valid values are \u2018CURRENT\u2019, \u2018FUTURE\u2019 and \u2018ALL\u2019. If absent defaults to &#39;CURRENT&#39;", in=ParamLocation.QUERY, defaultValue="CURRENT") ParamEffective var1, @Param(name="updated-since", description="Only include products that have been updated after the specified date and time. If absent defaults to include all products", in=ParamLocation.QUERY) @CDSDataType(value=CustomDataType.DateTime) String var2, @Param(name="brand", description="Filter results based on a specific brand", in=ParamLocation.QUERY) String var3, @Param(name="product-category", description="Used to filter results on the productCategory field applicable to accounts. Any one of the valid values for this field can be supplied. If absent then all accounts returned.", in=ParamLocation.QUERY, reference="ParamProductCategory") ParamProductCategory var4, @Param(name="page", description="Page of results to request (standard pagination)", in=ParamLocation.QUERY, defaultValue="1", reference="ParamPage") @CDSDataType(value=CustomDataType.PositiveInteger) Integer var5, @Param(name="page-size", description="Page size to request. Default is 25 (standard pagination)", in=ParamLocation.QUERY, defaultValue="25", reference="ParamPageSize") @CDSDataType(value=CustomDataType.PositiveInteger) Integer var6, @Param(name="x-v", description="Version of the API end point requested by the client. Must be set to a positive integer. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If the value of [x-min-v](#request-headers) is equal to or higher than the value of [x-v](#request-headers) then the [x-min-v](#request-headers) header should be treated as absent. If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable. See [HTTP Headers](#request-headers)", in=ParamLocation.HEADER, reference="RequestHeader_x-v") String var7, @Param(name="x-min-v", description="Minimum version of the API end point requested by the client. Must be set to a positive integer if provided. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable.", in=ParamLocation.HEADER, reference="RequestHeader_x-min-v") String var8);

    public static enum ParamEffective {
        CURRENT,
        FUTURE,
        ALL;

    }
}

