/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.support.util;

import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.CustomAttribute;
import au.org.consumerdatastandards.support.data.CustomAttributes;
import au.org.consumerdatastandards.support.model.ModelBase;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CustomAttributesUtil {
    public static void addCustomAttributes(AnnotatedElement annotatedElement, ModelBase model) {
        CustomAttributes customAttributes;
        CustomAttribute customAttribute = annotatedElement.getAnnotation(CustomAttribute.class);
        if (customAttribute != null) {
            model.add(customAttribute);
        }
        if ((customAttributes = annotatedElement.getAnnotation(CustomAttributes.class)) != null) {
            model.addAll(customAttributes.value());
        }
    }

    public static Map<String, Object> getGroupedAttributes(AnnotatedElement annotatedElement) {
        CustomAttributes customAttributes;
        TreeSet<CustomAttribute> attributes = new TreeSet<CustomAttribute>(Comparator.comparing(attribute -> attribute.name() + attribute.value()));
        CustomAttribute customAttribute = annotatedElement.getAnnotation(CustomAttribute.class);
        if (customAttribute != null) {
            attributes.add(customAttribute);
        }
        if ((customAttributes = annotatedElement.getAnnotation(CustomAttributes.class)) != null) {
            Collections.addAll(attributes, customAttributes.value());
        }
        Map<String, Object> groupedAttributes = CustomAttributesUtil.getGroupedAttributes(attributes);
        CDSDataType cdsDataType = annotatedElement.getAnnotation(CDSDataType.class);
        if (cdsDataType != null) {
            groupedAttributes.put("x-cds-type", cdsDataType.value().getName());
        }
        return groupedAttributes;
    }

    public static Map<String, Object> getGroupedAttributes(Set<CustomAttribute> attributes) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (CustomAttribute attribute : attributes) {
            if (attribute.multiple()) {
                Set<String> values = new TreeSet<String>();
                if (map.get(attribute.name()) != null) {
                    values = (Set)map.get(attribute.name());
                }
                values.add(attribute.value());
                map.put(attribute.name(), values);
                continue;
            }
            map.put(attribute.name(), attribute.value());
        }
        return map;
    }
}

