/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.support.model;

import au.org.consumerdatastandards.support.Endpoint;
import au.org.consumerdatastandards.support.Param;
import au.org.consumerdatastandards.support.Section;
import au.org.consumerdatastandards.support.model.APIModel;
import au.org.consumerdatastandards.support.model.EndpointModel;
import au.org.consumerdatastandards.support.model.ModelBuilderOptions;
import au.org.consumerdatastandards.support.model.ParamModel;
import au.org.consumerdatastandards.support.model.SectionModel;
import au.org.consumerdatastandards.support.util.CustomAttributesUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Set;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ModelBuilder {
    public static final String BASE_PACKAGE = "au.org.consumerdatastandards.api";
    private ModelBuilderOptions options;

    public ModelBuilder() {
    }

    public ModelBuilder(ModelBuilderOptions options) {
        this.options = options;
    }

    public APIModel build() {
        APIModel apiModel = new APIModel();
        Reflections reflections = new Reflections(BASE_PACKAGE, new Scanner[0]);
        Set sectionClasses = reflections.getTypesAnnotatedWith(Section.class);
        for (Class sectionClass : sectionClasses) {
            Section section = sectionClass.getAnnotation(Section.class);
            if (this.options != null && !this.options.isSectionIncluded(section.name())) continue;
            apiModel.add(this.buildSectionModel(section, sectionClass));
        }
        return apiModel;
    }

    private SectionModel buildSectionModel(Section section, Class<?> sectionClass) {
        SectionModel sectionModel = new SectionModel(section);
        CustomAttributesUtil.addCustomAttributes(sectionClass, sectionModel);
        for (Method method : MethodUtils.getMethodsListWithAnnotation(sectionClass, Endpoint.class, (boolean)true, (boolean)true)) {
            EndpointModel endpointModel = this.buildEndpointModel(method);
            sectionModel.add(endpointModel);
        }
        return sectionModel;
    }

    private EndpointModel buildEndpointModel(Method method) {
        Parameter[] parameters;
        Endpoint endpoint = method.getAnnotation(Endpoint.class);
        EndpointModel endpointModel = new EndpointModel(endpoint);
        CustomAttributesUtil.addCustomAttributes(method, endpointModel);
        for (Parameter parameter : parameters = method.getParameters()) {
            if (!parameter.isAnnotationPresent(Param.class)) continue;
            ParamModel paramModel = new ParamModel(parameter);
            CustomAttributesUtil.addCustomAttributes(parameter, paramModel);
            endpointModel.addParamModel(paramModel);
        }
        return endpointModel;
    }
}

