/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.support.model;

import au.org.consumerdatastandards.support.Endpoint;
import au.org.consumerdatastandards.support.ParamLocation;
import au.org.consumerdatastandards.support.model.ModelBase;
import au.org.consumerdatastandards.support.model.ParamModel;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class EndpointModel
extends ModelBase
implements Comparable<EndpointModel> {
    private Endpoint endpoint;
    private Set<ParamModel> paramModels = new TreeSet<ParamModel>();
    private Map<ParamLocation, Set<ParamModel>> paramsByLocation = new HashMap<ParamLocation, Set<ParamModel>>();

    public EndpointModel(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Set<ParamModel> getParamModels() {
        return this.paramModels;
    }

    public void addParamModel(ParamModel paramModel) {
        this.paramModels.add(paramModel);
        this.paramsByLocation.computeIfAbsent(paramModel.getParam().in(), k -> new LinkedHashSet());
        this.paramsByLocation.get((Object)paramModel.getParam().in()).add(paramModel);
    }

    @Override
    public int compareTo(EndpointModel endpointModel) {
        int result = this.endpoint.path().replaceAll("[\\{|\\}]", "").compareTo(endpointModel.endpoint.path().replaceAll("[\\{|\\}]", ""));
        if (result != 0) {
            return result;
        }
        return this.endpoint.requestMethod().name().compareTo(endpointModel.endpoint.requestMethod().name());
    }

    public Set<ParamModel> getHeadParams() {
        return this.paramsByLocation.get((Object)ParamLocation.HEADER);
    }

    public Set<ParamModel> getBodyParams() {
        return this.paramsByLocation.get((Object)ParamLocation.BODY);
    }

    public Set<ParamModel> getFormParams() {
        return this.paramsByLocation.get((Object)ParamLocation.FORM);
    }

    public Set<ParamModel> getQueryParams() {
        return this.paramsByLocation.get((Object)ParamLocation.QUERY);
    }

    public Set<ParamModel> getPathParams() {
        return this.paramsByLocation.get((Object)ParamLocation.PATH);
    }

    public Set<ParamModel> getCookieParams() {
        return this.paramsByLocation.get((Object)ParamLocation.COOKIE);
    }
}

