/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.support;

import au.org.consumerdatastandards.support.data.IntegerRange;
import java.util.Objects;

public class SemVer
implements Comparable<SemVer> {
    @IntegerRange(min=0)
    private final int major;
    @IntegerRange(min=0)
    private final int minor;
    @IntegerRange(min=0)
    private final int patch;

    public SemVer(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(SemVer o) {
        if (this.major != o.major) {
            return this.major - o.major;
        }
        if (this.minor != o.minor) {
            return this.minor - o.minor;
        }
        return this.patch - o.patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        return this.major == semVer.major && this.minor == semVer.minor && this.patch == semVer.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }
}

