/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.api.banking.models;

import au.org.consumerdatastandards.api.banking.models.BankingProductDiscountEligibility;
import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.Condition;
import au.org.consumerdatastandards.support.data.ConditionalCDSDataType;
import au.org.consumerdatastandards.support.data.CustomAttribute;
import au.org.consumerdatastandards.support.data.CustomAttributes;
import au.org.consumerdatastandards.support.data.CustomDataType;
import au.org.consumerdatastandards.support.data.DataDefinition;
import au.org.consumerdatastandards.support.data.Property;
import java.util.List;

@DataDefinition(anyOf={"amount", "balanceRate", "transactionRate", "accruedRate"})
@CustomAttributes(value={@CustomAttribute(name="x-conditional", value="balanceRate", multiple=true), @CustomAttribute(name="x-conditional", value="transactionRate", multiple=true), @CustomAttribute(name="x-conditional", value="accruedRate", multiple=true), @CustomAttribute(name="x-conditional", value="feeRate", multiple=true), @CustomAttribute(name="x-conditional", value="additionalValue", multiple=true)})
public class BankingProductDiscount {
    @Property(description="Description of the discount", required=true)
    String description;
    @Property(description="The type of discount. See the next section for an overview of valid values and their meaning", required=true)
    DiscountType discountType;
    @Property(description="Value of the discount", required=true)
    @CDSDataType(value=CustomDataType.Amount)
    String amount;
    @Property(description="A discount rate calculated based on a proportion of the balance. Note that the currency of the fee discount is expected to be the same as the currency of the fee itself. One of amount, balanceRate, transactionRate, accruedRate and feeRate is mandatory. Unless noted in additionalInfo, assumes the application and calculation frequency are the same as the corresponding fee")
    @CDSDataType(value=CustomDataType.Rate)
    String balanceRate;
    @Property(description="A discount rate calculated based on a proportion of a transaction. Note that the currency of the fee discount is expected to be the same as the currency of the fee itself. One of amount, balanceRate, transactionRate, accruedRate and feeRate is mandatory")
    @CDSDataType(value=CustomDataType.Rate)
    String transactionRate;
    @Property(description="A discount rate calculated based on a proportion of the calculated interest accrued on the account. Note that the currency of the fee discount is expected to be the same as the currency of the fee itself. One of amount, balanceRate, transactionRate, accruedRate and feeRate is mandatory. Unless noted in additionalInfo, assumes the application and calculation frequency are the same as the corresponding fee")
    @CDSDataType(value=CustomDataType.Rate)
    String accruedRate;
    @Property(description="A discount rate calculated based on a proportion of the fee to which this discount is attached. Note that the currency of the fee discount is expected to be the same as the currency of the fee itself. One of amount, balanceRate, transactionRate, accruedRate and feeRate is mandatory. Unless noted in additionalInfo, assumes the application and calculation frequency are the same as the corresponding fee")
    @CDSDataType(value=CustomDataType.Rate)
    String feeRate;
    @Property(description="Generic field containing additional information relevant to the [discountType](#tocSproductdiscounttypedoc) specified. Whether mandatory or not is dependent on the value of [discountType](#tocSproductdiscounttypedoc)", requiredIf={@Condition(propertyName="discountType", values={"BALANCE", "DEPOSITS", "PAYMENTS", "FEE_CAP"}, conditionalCDSDataTypes={@ConditionalCDSDataType(value="BALANCE", cdsDataType=@CDSDataType(value=CustomDataType.Amount)), @ConditionalCDSDataType(value="DEPOSITS", cdsDataType=@CDSDataType(value=CustomDataType.Amount)), @ConditionalCDSDataType(value="PAYMENTS", cdsDataType=@CDSDataType(value=CustomDataType.Amount)), @ConditionalCDSDataType(value="FEE_CAP", cdsDataType=@CDSDataType(value=CustomDataType.Duration))})})
    String additionalValue;
    @Property(description="Display text providing more information on the discount")
    String additionalInfo;
    @Property(description="Link to a web page with more information on this discount")
    @CDSDataType(value=CustomDataType.URI)
    String additionalInfoUri;
    @Property(description="Eligibility constraints that apply to this discount")
    List<BankingProductDiscountEligibility> eligibility;

    public static enum DiscountType {
        BALANCE,
        DEPOSITS,
        PAYMENTS,
        FEE_CAP,
        ELIGIBILITY_ONLY;

    }
}

