/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.api.banking.models;

import au.org.consumerdatastandards.api.banking.models.BankingAccount;
import au.org.consumerdatastandards.api.banking.models.BankingCreditCardAccount;
import au.org.consumerdatastandards.api.banking.models.BankingLoanAccount;
import au.org.consumerdatastandards.api.banking.models.BankingProductDepositRate;
import au.org.consumerdatastandards.api.banking.models.BankingProductFee;
import au.org.consumerdatastandards.api.banking.models.BankingProductLendingRate;
import au.org.consumerdatastandards.api.banking.models.BankingTermDepositAccount;
import au.org.consumerdatastandards.api.common.models.CommonPhysicalAddress;
import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.CustomAttribute;
import au.org.consumerdatastandards.support.data.CustomAttributes;
import au.org.consumerdatastandards.support.data.CustomDataType;
import au.org.consumerdatastandards.support.data.DataDefinition;
import au.org.consumerdatastandards.support.data.Property;
import java.util.List;

@DataDefinition(allOf={BankingAccount.class})
@CustomAttributes(value={@CustomAttribute(name="x-conditional", value="termDeposit", multiple=true), @CustomAttribute(name="x-conditional", value="creditCard", multiple=true), @CustomAttribute(name="x-conditional", value="loan", multiple=true)})
public class BankingAccountDetail {
    @Property(description="The unmasked BSB for the account. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces")
    String bsb;
    @Property(description="The unmasked account number for the account. Should not be supplied if the account number is a PAN requiring PCI compliance. Is expected to be formatted as digits only with leading zeros included and no punctuation or spaces")
    String accountNumber;
    @Property(description="Optional field to indicate if this account is part of a bundle that is providing additional benefit for to the customer")
    String bundleName;
    @Property(description="The type of structure to present account specific fields.")
    SpecificAccountUType specificAccountUType;
    @Property
    BankingTermDepositAccount termDeposit;
    @Property
    BankingCreditCardAccount creditCard;
    @Property
    BankingLoanAccount loan;
    @Property(description="current rate to calculate interest earned being applied to deposit balances as it stands at the time of the API call")
    @CDSDataType(value=CustomDataType.Rate)
    String depositRate;
    @Property(description="The current rate to calculate interest payable being applied to lending balances as it stands at the time of the API call")
    @CDSDataType(value=CustomDataType.Rate)
    String lendingRate;
    @Property(description="Fully described deposit rates for this account based on the equivalent structure in Product Reference")
    List<BankingProductDepositRate> depositRates;
    @Property(description="Fully described deposit rates for this account based on the equivalent structure in Product Reference")
    List<BankingProductLendingRate> lendingRates;
    @Property(description="Array of features of the account based on the equivalent structure in Product Reference with the following additional field")
    List<Object> features;
    @Property(description="Fees and charges applicable to the account based on the equivalent structure in Product Reference")
    List<BankingProductFee> fees;
    @Property(description="The addresses for the account to be used for correspondence")
    List<CommonPhysicalAddress> addresses;

    public static enum SpecificAccountUType {
        termDeposit,
        creditCard,
        loan;

    }
}

